/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFItems;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.network.ParticlePacket;
import twilightforest.util.WorldUtil;

public class CubeOfAnnihilation
extends ThrowableProjectile {
    private boolean hasHitObstacle = false;
    private ItemStack stack;

    public CubeOfAnnihilation(EntityType<? extends CubeOfAnnihilation> type, Level world) {
        super(type, world);
    }

    public CubeOfAnnihilation(EntityType<? extends CubeOfAnnihilation> type, Level world, LivingEntity thrower, ItemStack stack) {
        super(type, thrower, world);
        this.shootFromRotation((Entity)thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, 1.5f, 1.0f);
        this.stack = stack;
    }

    public boolean canUsePortal(boolean force) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (result.getEntity() instanceof LivingEntity && result.getEntity().hurt(this.getDamageSource(), 10.0f)) {
            this.tickCount += 60;
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!this.level().isEmptyBlock(result.getBlockPos())) {
            this.affectBlocksInAABB(this.getBoundingBox().inflate((double)0.2f, (double)0.2f, (double)0.2f));
        }
    }

    protected void onHit(HitResult result) {
        HitResult.Type hitresult$type = result.getType();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)result);
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)result);
        }
    }

    private DamageSource getDamageSource() {
        LivingEntity thrower = (LivingEntity)this.getOwner();
        if (thrower instanceof Player) {
            return this.damageSources().playerAttack((Player)thrower);
        }
        if (thrower != null) {
            return this.damageSources().mobAttack(thrower);
        }
        return this.damageSources().thrown((Entity)this, null);
    }

    private void affectBlocksInAABB(AABB box) {
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            Entity entity;
            BlockState state = this.level().getBlockState(pos);
            if (state.isAir() || !((entity = this.getOwner()) instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            if (!((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.level(), pos, state, (Player)player))).isCanceled()) {
                if (this.canAnnihilate(pos, state, player.gameMode.getGameModeForPlayer().isBlockPlacingRestricted())) {
                    this.level().removeBlock(pos, false);
                    this.playSound((SoundEvent)TFSounds.BLOCK_ANNIHILATED.get(), 0.125f, this.random.nextFloat() * 0.25f + 0.75f);
                    this.annihilateParticles(this.level(), pos);
                    this.gameEvent((Holder)GameEvent.BLOCK_DESTROY);
                    continue;
                }
                this.hasHitObstacle = true;
                continue;
            }
            this.hasHitObstacle = true;
        }
    }

    private boolean canAnnihilate(BlockPos pos, BlockState state, boolean restrictedPlaceMode) {
        Block block = state.getBlock();
        return (state.is(BlockTagGenerator.ANNIHILATION_INCLUSIONS) || block.getExplosionResistance() < 8.0f && state.getDestroySpeed((BlockGetter)this.level(), pos) >= 0.0f) && (!restrictedPlaceMode || this.stack.canBreakBlockInAdventureMode(new BlockInWorld((LevelReader)this.level(), pos, false)));
    }

    private void annihilateParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            RandomSource rand = level.getRandom();
            ParticlePacket particlePacket = new ParticlePacket();
            for (int dx = 0; dx < 3; ++dx) {
                for (int dy = 0; dy < 3; ++dy) {
                    for (int dz = 0; dz < 3; ++dz) {
                        particlePacket.queueParticle((ParticleOptions)TFParticleType.ANNIHILATE.get(), false, (double)pos.getX() + ((double)dx + 0.5) / 4.0, (double)pos.getY() + ((double)dy + 0.5) / 4.0, (double)pos.getZ() + ((double)dz + 0.5) / 4.0, rand.nextGaussian() * 0.2, rand.nextGaussian() * 0.2, rand.nextGaussian() * 0.2);
                    }
                }
            }
            PacketDistributor.sendToPlayersNear((ServerLevel)server, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)32.0, (CustomPacketPayload)particlePacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getOwner() == null) {
                this.remove(Entity.RemovalReason.KILLED);
                return;
            }
            Vec3 destPoint = new Vec3(this.getOwner().getX(), this.getOwner().getY() + (double)this.getOwner().getEyeHeight(), this.getOwner().getZ());
            double distToPlayer = this.distanceTo(this.getOwner());
            if (this.isReturning()) {
                if (distToPlayer < 2.0) {
                    this.remove(Entity.RemovalReason.KILLED);
                }
            } else {
                destPoint = destPoint.add(this.getOwner().getLookAngle().scale(16.0));
            }
            Vec3 velocity = new Vec3(this.getX() - destPoint.x(), this.getY() + (double)(this.getBbHeight() / 2.0f) - destPoint.y(), this.getZ() - destPoint.z());
            this.setDeltaMovement(-velocity.x(), -velocity.y(), -velocity.z());
            float currentSpeed = Mth.sqrt((float)((float)(this.getDeltaMovement().x() * this.getDeltaMovement().x() + this.getDeltaMovement().y() * this.getDeltaMovement().y() + this.getDeltaMovement().z() * this.getDeltaMovement().z())));
            float maxSpeed = 0.5f;
            if (currentSpeed > maxSpeed) {
                this.setDeltaMovement(new Vec3(this.getDeltaMovement().x() / (double)(currentSpeed / maxSpeed), this.getDeltaMovement().y() / (double)(currentSpeed / maxSpeed), this.getDeltaMovement().z() / (double)(currentSpeed / maxSpeed)));
            } else {
                float slow = 0.5f;
                this.getDeltaMovement().multiply((double)slow, (double)slow, (double)slow);
            }
            this.affectBlocksInAABB(this.getBoundingBox().inflate((double)0.2f));
        }
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        LivingEntity thrower = (LivingEntity)this.getOwner();
        if (thrower != null && thrower.getUseItem().is((Item)TFItems.CUBE_OF_ANNIHILATION.get())) {
            thrower.stopUsingItem();
        }
    }

    private boolean isReturning() {
        Entity entity;
        if (this.hasHitObstacle || this.getOwner() == null || !((entity = this.getOwner()) instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        return !player.isUsingItem();
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("CubeOfAnnihilationStack", 10)) {
            this.stack = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)pCompound.getCompound("CubeOfAnnihilationStack"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.put("CubeOfAnnihilationStack", this.stack.save((HolderLookup.Provider)this.registryAccess()));
    }
}

