/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import java.util.List;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import twilightforest.TFRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFDensityFunctions;
import twilightforest.init.TFDimension;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.layer.BiomeDensitySource;
import twilightforest.world.registration.surface_rules.TFSurfaceRules;

public class TFDimensionData {
    @Deprecated
    public static final int SEALEVEL = 0;
    public static final ResourceKey<DimensionType> TWILIGHT_DIM_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)TwilightForestMod.prefix("twilight_forest_type"));
    public static final ResourceKey<NoiseGeneratorSettings> TWILIGHT_NOISE_GEN = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)TwilightForestMod.prefix("twilight_noise_gen"));
    public static final ResourceKey<NoiseGeneratorSettings> SKYLIGHT_NOISE_GEN = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)TwilightForestMod.prefix("skylight_noise_gen"));
    public static final ResourceKey<LevelStem> TWILIGHT_LEVEL_STEM = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)TFDimension.DIMENSION);

    private static DimensionType twilightDimType() {
        return new DimensionType(OptionalLong.of(13000L), true, false, false, true, 0.125, true, false, -32, 288, 288, BlockTags.INFINIBURN_OVERWORLD, TFDimension.DIMENSION_RENDERER, 0.01f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.of((int)0, (int)7), 7));
    }

    public static void bootstrapType(BootstrapContext<DimensionType> context) {
        context.register(TWILIGHT_DIM_TYPE, (Object)TFDimensionData.twilightDimType());
    }

    public static NoiseGeneratorSettings makeNoiseSettings(BootstrapContext<NoiseGeneratorSettings> context, boolean skylight) {
        HolderGetter densityFunctions = context.lookup(Registries.DENSITY_FUNCTION);
        DensityFunctions.HolderHolder finalDensity = new DensityFunctions.HolderHolder((Holder)densityFunctions.getOrThrow(skylight ? TFDensityFunctions.SKYLIGHT_TERRAIN : TFDensityFunctions.FORESTED_TERRAIN));
        NoiseSettings tfNoise = NoiseSettings.create((int)-32, (int)256, (int)2, (int)2);
        return new NoiseGeneratorSettings(tfNoise, Blocks.STONE.defaultBlockState(), skylight ? Blocks.AIR.defaultBlockState() : Blocks.WATER.defaultBlockState(), new NoiseRouter(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), (DensityFunction)finalDensity, (DensityFunction)finalDensity, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero()), TFSurfaceRules.tfSurface(), List.of(), 0, false, false, false, false);
    }

    public static void bootstrapNoise(BootstrapContext<NoiseGeneratorSettings> context) {
        context.register(TWILIGHT_NOISE_GEN, (Object)TFDimensionData.makeNoiseSettings(context, false));
        context.register(SKYLIGHT_NOISE_GEN, (Object)TFDimensionData.makeNoiseSettings(context, true));
    }

    public static void bootstrapStem(BootstrapContext<LevelStem> context) {
        HolderGetter dimTypes = context.lookup(Registries.DIMENSION_TYPE);
        HolderGetter noiseGenSettings = context.lookup(Registries.NOISE_SETTINGS);
        HolderGetter biomeDataRegistry = context.lookup(TFRegistries.Keys.BIOME_TERRAIN_DATA);
        NoiseBasedChunkGenerator twilightChunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)new TFBiomeProvider((Holder<BiomeDensitySource>)biomeDataRegistry.getOrThrow(BiomeLayerStack.BIOME_GRID)), (Holder)noiseGenSettings.getOrThrow(TWILIGHT_NOISE_GEN));
        LevelStem stem = new LevelStem((Holder)dimTypes.getOrThrow(TWILIGHT_DIM_TYPE), (ChunkGenerator)twilightChunkGenerator);
        context.register(TWILIGHT_LEVEL_STEM, (Object)stem);
    }
}

