/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record ColorUtil(Function<DyeColor, Block> function) {
    public static final ColorUtil WOOL = new ColorUtil(color -> switch (color) {
        default -> Blocks.WHITE_WOOL;
        case DyeColor.ORANGE -> Blocks.ORANGE_WOOL;
        case DyeColor.MAGENTA -> Blocks.MAGENTA_WOOL;
        case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_WOOL;
        case DyeColor.YELLOW -> Blocks.YELLOW_WOOL;
        case DyeColor.LIME -> Blocks.LIME_WOOL;
        case DyeColor.PINK -> Blocks.PINK_WOOL;
        case DyeColor.GRAY -> Blocks.GRAY_WOOL;
        case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_WOOL;
        case DyeColor.CYAN -> Blocks.CYAN_WOOL;
        case DyeColor.PURPLE -> Blocks.PURPLE_WOOL;
        case DyeColor.BLUE -> Blocks.BLUE_WOOL;
        case DyeColor.BROWN -> Blocks.BROWN_WOOL;
        case DyeColor.GREEN -> Blocks.GREEN_WOOL;
        case DyeColor.RED -> Blocks.RED_WOOL;
        case DyeColor.BLACK -> Blocks.BLACK_WOOL;
    });
    public static final ColorUtil TERRACOTTA = new ColorUtil(color -> switch (color) {
        default -> Blocks.WHITE_TERRACOTTA;
        case DyeColor.ORANGE -> Blocks.ORANGE_TERRACOTTA;
        case DyeColor.MAGENTA -> Blocks.MAGENTA_TERRACOTTA;
        case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_TERRACOTTA;
        case DyeColor.YELLOW -> Blocks.YELLOW_TERRACOTTA;
        case DyeColor.LIME -> Blocks.LIME_TERRACOTTA;
        case DyeColor.PINK -> Blocks.PINK_TERRACOTTA;
        case DyeColor.GRAY -> Blocks.GRAY_TERRACOTTA;
        case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_TERRACOTTA;
        case DyeColor.CYAN -> Blocks.CYAN_TERRACOTTA;
        case DyeColor.PURPLE -> Blocks.PURPLE_TERRACOTTA;
        case DyeColor.BLUE -> Blocks.BLUE_TERRACOTTA;
        case DyeColor.BROWN -> Blocks.BROWN_TERRACOTTA;
        case DyeColor.GREEN -> Blocks.GREEN_TERRACOTTA;
        case DyeColor.RED -> Blocks.RED_TERRACOTTA;
        case DyeColor.BLACK -> Blocks.BLACK_TERRACOTTA;
    });
    public static final ColorUtil STAINED_GLASS = new ColorUtil(color -> switch (color) {
        default -> Blocks.WHITE_STAINED_GLASS;
        case DyeColor.ORANGE -> Blocks.ORANGE_STAINED_GLASS;
        case DyeColor.MAGENTA -> Blocks.MAGENTA_STAINED_GLASS;
        case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_STAINED_GLASS;
        case DyeColor.YELLOW -> Blocks.YELLOW_STAINED_GLASS;
        case DyeColor.LIME -> Blocks.LIME_STAINED_GLASS;
        case DyeColor.PINK -> Blocks.PINK_STAINED_GLASS;
        case DyeColor.GRAY -> Blocks.GRAY_STAINED_GLASS;
        case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_STAINED_GLASS;
        case DyeColor.CYAN -> Blocks.CYAN_STAINED_GLASS;
        case DyeColor.PURPLE -> Blocks.PURPLE_STAINED_GLASS;
        case DyeColor.BLUE -> Blocks.BLUE_STAINED_GLASS;
        case DyeColor.BROWN -> Blocks.BROWN_STAINED_GLASS;
        case DyeColor.GREEN -> Blocks.GREEN_STAINED_GLASS;
        case DyeColor.RED -> Blocks.RED_STAINED_GLASS;
        case DyeColor.BLACK -> Blocks.BLACK_STAINED_GLASS;
    });
    public static final Map<DyeColor, Block> WOOL_TO_DYE_IN_RAM_ORDER = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{ColorUtil.entryOf(DyeColor.WHITE, Blocks.WHITE_WOOL), ColorUtil.entryOf(DyeColor.LIGHT_GRAY, Blocks.LIGHT_GRAY_WOOL), ColorUtil.entryOf(DyeColor.GRAY, Blocks.GRAY_WOOL), ColorUtil.entryOf(DyeColor.BLACK, Blocks.BLACK_WOOL), ColorUtil.entryOf(DyeColor.RED, Blocks.RED_WOOL), ColorUtil.entryOf(DyeColor.ORANGE, Blocks.ORANGE_WOOL), ColorUtil.entryOf(DyeColor.YELLOW, Blocks.YELLOW_WOOL), ColorUtil.entryOf(DyeColor.LIME, Blocks.LIME_WOOL), ColorUtil.entryOf(DyeColor.GREEN, Blocks.GREEN_WOOL), ColorUtil.entryOf(DyeColor.LIGHT_BLUE, Blocks.LIGHT_BLUE_WOOL), ColorUtil.entryOf(DyeColor.CYAN, Blocks.CYAN_WOOL), ColorUtil.entryOf(DyeColor.BLUE, Blocks.BLUE_WOOL), ColorUtil.entryOf(DyeColor.PURPLE, Blocks.PURPLE_WOOL), ColorUtil.entryOf(DyeColor.MAGENTA, Blocks.MAGENTA_WOOL), ColorUtil.entryOf(DyeColor.PINK, Blocks.PINK_WOOL), ColorUtil.entryOf(DyeColor.BROWN, Blocks.BROWN_WOOL)});

    public BlockState getColor(DyeColor color) {
        return this.function.apply(color).defaultBlockState();
    }

    public Block getRandomColor(Random rand) {
        DyeColor color = DyeColor.byId((int)rand.nextInt(16));
        return this.getColor(color).getBlock();
    }

    public static float[] rgbToHSV(int r, int g, int b) {
        float s;
        float h = 0.0f;
        float rabs = (float)r / 255.0f;
        float gabs = (float)g / 255.0f;
        float babs = (float)b / 255.0f;
        float v = Math.max(rabs, Math.max(gabs, babs));
        float diff = v - Math.min(rabs, Math.min(gabs, babs));
        Function<Float, Float> diffc = c -> Float.valueOf((v - c.floatValue()) / 6.0f / diff + 0.0f);
        if (diff == 0.0f) {
            s = 0.0f;
            h = 0.0f;
        } else {
            s = diff / v;
            float rr = diffc.apply(Float.valueOf(rabs)).floatValue();
            float gg = diffc.apply(Float.valueOf(gabs)).floatValue();
            float bb = diffc.apply(Float.valueOf(babs)).floatValue();
            if (rabs == v) {
                h = bb - gg;
            } else if (gabs == v) {
                h = 0.33333334f + rr - bb;
            } else if (babs == v) {
                h = 0.6666667f + gg - rr;
            }
            if (h < 0.0f) {
                h += 1.0f;
            } else if (h > 1.0f) {
                h -= 1.0f;
            }
        }
        return new float[]{h, s, v};
    }

    public static int hsvToRGB(float hue, float saturation, float value) {
        float normaliedHue = hue - (float)Math.floor(hue);
        int h = (int)(normaliedHue * 6.0f);
        float f = normaliedHue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        return switch (h) {
            case 0 -> ColorUtil.rgb(value, t, p);
            case 1 -> ColorUtil.rgb(q, value, p);
            case 2 -> ColorUtil.rgb(p, value, t);
            case 3 -> ColorUtil.rgb(p, q, value);
            case 4 -> ColorUtil.rgb(t, p, value);
            case 5 -> ColorUtil.rgb(value, p, q);
            default -> throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
        };
    }

    private static int rgb(float r, float g, float b) {
        return ((int)(r * 255.0f + 0.5f) & 0xFF) << 16 | ((int)(g * 255.0f + 0.5f) & 0xFF) << 8 | (int)(b * 255.0f + 0.5f) & 0xFF;
    }

    public static int argbToABGR(int argbColor) {
        int r = argbColor >> 16 & 0xFF;
        int b = argbColor & 0xFF;
        return argbColor & 0xFF00FF00 | b << 16 | r;
    }

    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static int blendColors(int a, int b, double ratio) {
        int mask1 = 0xFF00FF;
        int mask2 = -16711936;
        int f2 = (int)(256.0 * ratio);
        int f1 = 256 - f2;
        return (a & mask1) * f1 + (b & mask1) * f2 >> 8 & mask1 | (a & mask2) * f1 + (b & mask2) * f2 >> 8 & mask2;
    }
}

