/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.entities;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import twilightforest.TwilightForestMod;

public class EntityRenderingUtil {
    private static final Set<EntityType<?>> IGNORED_ENTITIES = new HashSet();
    private static final Map<EntityType<?>, Entity> ENTITY_MAP = new HashMap();

    @Nullable
    public static Entity fetchEntity(EntityType<?> type, @Nullable Level level) {
        if (level != null && !IGNORED_ENTITIES.contains(type)) {
            Object entity = type == EntityType.PLAYER ? Minecraft.getInstance().player : ENTITY_MAP.computeIfAbsent(type, t -> {
                Entity created = t.create(level);
                if (created != null) {
                    created.setYRot(0.0f);
                    created.setYHeadRot(0.0f);
                    created.setYBodyRot(0.0f);
                    created.hasImpulse = false;
                    if (created instanceof Mob) {
                        Mob mob = (Mob)created;
                        mob.setNoAi(true);
                    }
                }
                return created;
            });
            return entity;
        }
        return null;
    }

    public static void renderEntity(GuiGraphics graphics, EntityType<?> type, int size) {
        Entity entity = EntityRenderingUtil.fetchEntity(type, (Level)Minecraft.getInstance().level);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            int scale = size / 2;
            float height = entity.getBbHeight();
            float width = entity.getBbWidth();
            if (height > 2.25f || width > 2.25f) {
                scale = (int)(20.0f / Math.max(height, width));
            }
            try {
                EntityRenderingUtil.renderTheEntity(graphics, size / 2, size - 2, scale, living);
            }
            catch (Exception e) {
                TwilightForestMod.LOGGER.error("Error drawing entity " + String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey(type)), (Throwable)e);
                IGNORED_ENTITIES.add(type);
                ENTITY_MAP.remove(type);
            }
        }
    }

    private static void renderTheEntity(GuiGraphics graphics, int x, int y, int scale, LivingEntity entity) {
        PoseStack posestack = graphics.pose();
        Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf quaternion1 = Axis.XP.rotationDegrees(20.0f);
        quaternion.mul((Quaternionfc)quaternion1);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 0.0f;
        entity.setYRot(0.0f);
        entity.setXRot(0.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        posestack.pushPose();
        posestack.translate((double)x, (double)y, 50.0);
        EntityRenderingUtil.applyAdditionalTransforms(entity.getType(), posestack);
        posestack.scale((float)scale, (float)scale, (float)(-scale));
        posestack.mulPose(quaternion);
        posestack.mulPose(Axis.XN.rotationDegrees(35.0f));
        posestack.mulPose(Axis.YN.rotationDegrees(145.0f));
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        quaternion1.conjugate();
        dispatcher.overrideCameraOrientation(quaternion1);
        boolean hitboxes = dispatcher.shouldRenderHitBoxes();
        dispatcher.setRenderShadow(false);
        dispatcher.setRenderHitBoxes(false);
        RenderSystem.runAsFancy(() -> dispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, posestack, (MultiBufferSource)graphics.bufferSource(), 0xF000F0));
        graphics.flush();
        dispatcher.setRenderShadow(true);
        dispatcher.setRenderHitBoxes(hitboxes);
        posestack.popPose();
        Lighting.setupFor3DItems();
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }

    private static void applyAdditionalTransforms(EntityType<?> entity, PoseStack stack) {
        if (entity == EntityType.GHAST) {
            stack.translate(0.0, -12.5, 0.0);
            stack.scale(0.5f, 0.5f, 0.5f);
        }
        if (entity == EntityType.ENDER_DRAGON) {
            stack.translate(0.0, -4.0, 0.0);
        }
        if (entity == EntityType.WITHER) {
            stack.translate(0.0, 8.0, 0.0);
        }
        if (entity == EntityType.SQUID || entity == EntityType.GLOW_SQUID) {
            stack.translate(0.0, -19.0, 0.0);
        }
        if (entity == EntityType.ELDER_GUARDIAN) {
            stack.scale(0.6f, 0.6f, 0.6f);
        }
    }

    public static void renderItemEntity(GuiGraphics graphics, ItemStack stack, @Nullable Level level, float bobOffset) {
        PoseStack posestack = graphics.pose();
        posestack.pushPose();
        posestack.translate(16.0, 32.0, 50.0);
        posestack.scale(50.0f, 50.0f, -50.0f);
        Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf quaternion1 = Axis.XP.rotationDegrees(20.0f);
        quaternion.mul((Quaternionfc)quaternion1);
        posestack.mulPose(quaternion);
        posestack.mulPose(Axis.XN.rotationDegrees(35.0f));
        posestack.mulPose(Axis.YN.rotationDegrees(145.0f));
        Lighting.setupForEntityInInventory();
        quaternion1.conjugate();
        ItemEntity item = (ItemEntity)EntityRenderingUtil.fetchEntity(EntityType.ITEM, level);
        Objects.requireNonNull(item).setItem(stack);
        RenderSystem.runAsFancy(() -> EntityRenderingUtil.render(item, Minecraft.getInstance().getTimer().getGameTimeDeltaTicks(), posestack, (MultiBufferSource)graphics.bufferSource(), bobOffset));
        graphics.flush();
        posestack.popPose();
        Lighting.setupFor3DItems();
    }

    private static void render(ItemEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, float bobOffset) {
        stack.pushPose();
        ItemStack itemstack = entity.getItem();
        BakedModel bakedmodel = Minecraft.getInstance().getItemRenderer().getModel(itemstack, entity.level(), null, entity.getId());
        float f1 = Mth.sin((float)(((float)Objects.requireNonNull(Minecraft.getInstance().level).getGameTime() + partialTicks) / 10.0f + bobOffset)) * 0.1f + 0.1f;
        float f2 = bakedmodel.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
        stack.translate(0.0, (double)(f1 + 0.25f * f2), 0.0);
        float f3 = EntityRenderingUtil.getSpin(partialTicks, bobOffset);
        stack.mulPose(Axis.YP.rotation(f3));
        stack.pushPose();
        Minecraft.getInstance().getItemRenderer().render(itemstack, ItemDisplayContext.GROUND, false, stack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
        stack.popPose();
        stack.popPose();
    }

    private static float getSpin(float partialTicks, float bobOffset) {
        return ((float)Objects.requireNonNull(Minecraft.getInstance().level).getGameTime() + partialTicks) / 20.0f + bobOffset;
    }

    public static List<Component> getMobTooltip(EntityType<?> type) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(type.getDescription());
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            components.add((Component)Component.literal((String)BuiltInRegistries.ENTITY_TYPE.getKey(type).toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        return components;
    }

    public static String getModIdForTooltip(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElseGet(() -> StringUtils.capitalize((String)modId));
    }
}

