/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.init.TFBlocks;
import twilightforest.util.RootPlacer;
import twilightforest.util.features.FeaturePlacers;
import twilightforest.util.features.FeatureUtil;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFTreeFeature;

public class MiningTreeFeature
extends TFTreeFeature<TFTreeFeatureConfig> {
    public MiningTreeFeature(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RootPlacer decorationPlacer, TFTreeFeatureConfig config) {
        if (world.isOutsideBuildHeight(pos.getY() + 12)) {
            return false;
        }
        if (world.getBlockState(pos.below()).canSustainPlant((BlockGetter)world, pos.below(), Direction.UP, ((SaplingBlock)TFBlocks.MINING_SAPLING.get()).defaultBlockState()).isFalse()) {
            return false;
        }
        for (int dy = 0; dy <= 9; ++dy) {
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, pos.above(dy), config.trunkProvider);
        }
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.offset(0, 9, 1), true, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.offset(0, 9, 2), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.offset(0, 8, 3), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.offset(0, 7, 4), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.offset(0, 6, 5), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.offset(0, 9, -1), true, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.offset(0, 9, -2), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.offset(0, 8, -3), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.offset(0, 7, -4), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.offset(0, 6, -5), false, config);
        BlockState stateAtCorePos = world.getBlockState(pos.above());
        if (stateAtCorePos.is(BlockTags.LOGS) || stateAtCorePos.canBeReplaced()) {
            world.setBlock(pos.above(), (BlockState)((Block)TFBlocks.MINING_LOG_CORE.get()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y), 3);
            world.scheduleTick(pos.above(), (Block)TFBlocks.MINING_LOG_CORE.get(), 20);
        }
        if (FeatureUtil.hasAirAround((LevelAccessor)world, pos.below())) {
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, pos.below(), config.trunkProvider);
        } else {
            FeaturePlacers.placeIfValidRootPos((LevelSimulatedReader)world, decorationPlacer, random, pos.below(), config.rootsProvider);
        }
        int numRoots = 3 + random.nextInt(2);
        float offset = random.nextFloat();
        for (int b = 0; b < numRoots; ++b) {
            FeaturePlacers.buildRoot((LevelAccessor)world, decorationPlacer, random, pos, offset, b, config.rootsProvider);
        }
        return true;
    }

    protected static void putBranchWithLeaves(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource rand, BlockPos pos, boolean bushy, TFTreeFeatureConfig config) {
        FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, rand, pos, config.branchProvider);
        for (int lx = -1; lx <= 1; ++lx) {
            for (int ly = -1; ly <= 1; ++ly) {
                for (int lz = -1; lz <= 1; ++lz) {
                    if (!bushy && Math.abs(ly) > 0 && Math.abs(lx) > 0) continue;
                    FeaturePlacers.placeProvidedBlock((LevelSimulatedReader)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, pos.offset(lx, ly, lz), config.leavesProvider, rand);
                }
            }
        }
    }
}

