/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer.vanillalegacy.context;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.world.level.biome.Biome;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.layer.vanillalegacy.Area;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.BigContext;

public class LazyAreaContext
implements BigContext<LazyArea> {
    private final ConcurrentHashMap<Long, ResourceKey<Biome>> cache;
    private final LinkedBlockingQueue<Long> evictionQueue;
    private final int maxCache;
    private final long seed;

    public LazyAreaContext(int maxCache, long salt) {
        this.seed = LazyAreaContext.mixSeed(WorldUtil.getOverworldSeed(), salt);
        this.cache = new ConcurrentHashMap();
        this.evictionQueue = new LinkedBlockingQueue();
        this.maxCache = maxCache;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public LazyArea createResult(Area transformer) {
        return new LazyArea(this.cache, this.evictionQueue, this.maxCache, transformer);
    }

    @Override
    public LazyArea createResult(Area transformer, LazyArea layer) {
        return new LazyArea(this.cache, this.evictionQueue, Math.min(1024, layer.getMaxCache() * 4), transformer);
    }

    @Override
    public LazyArea createResult(Area transformer, LazyArea layer1, LazyArea layer2) {
        return new LazyArea(this.cache, this.evictionQueue, Math.min(1024, Math.max(layer1.getMaxCache(), layer2.getMaxCache()) * 4), transformer);
    }

    private static long mixSeed(long seed, long salt) {
        long i = LinearCongruentialGenerator.next((long)salt, (long)salt);
        i = LinearCongruentialGenerator.next((long)i, (long)salt);
        i = LinearCongruentialGenerator.next((long)i, (long)salt);
        long j = LinearCongruentialGenerator.next((long)seed, (long)i);
        j = LinearCongruentialGenerator.next((long)j, (long)i);
        return LinearCongruentialGenerator.next((long)j, (long)i);
    }
}

