/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.icetower;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class IceTowerBeardComponent
extends TFStructureComponentOld {
    protected final int size;
    protected final int height;

    public IceTowerBeardComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFITBea.get(), nbt);
        this.size = nbt.getInt("beardSize");
        this.height = nbt.getInt("beardHeight");
    }

    public IceTowerBeardComponent(int i, TowerWingComponent wing, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFITBea.get(), i, x, y, z);
        this.setOrientation(wing.getOrientation());
        this.size = wing.size;
        this.height = Math.round((float)this.size * 1.414f);
        this.deco = wing.deco;
        this.boundingBox = new BoundingBox(wing.getBoundingBox().minX(), wing.getBoundingBox().minY() - this.height, wing.getBoundingBox().minZ(), wing.getBoundingBox().maxX(), wing.getBoundingBox().minY(), wing.getBoundingBox().maxZ());
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.addAdditionalSaveData(ctx, tagCompound);
        tagCompound.putInt("beardSize", this.size);
        tagCompound.putInt("beardHeight", this.height);
    }

    public void postProcess(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                int rHeight = Math.round(Mth.sqrt((float)(x * x + z * z)));
                for (int y = 0; y < rHeight; ++y) {
                    this.placeBlock(world, this.deco.blockState, x, this.height - y, z, sbb);
                }
            }
        }
    }
}

