/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.client;

import com.dooji.underlay.client.UnderlayManagerClient;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.NeoForge;

public class UnderlayRenderer {
    private static final Map<BlockPos, BlockState> RENDER_CACHE = new ConcurrentHashMap<BlockPos, BlockState>();
    private static long lastFullRefreshTime = 0L;
    private static final long FULL_REFRESH_INTERVAL = 500L;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(UnderlayRenderer::onRenderLevel);
    }

    public static void registerOverlay(BlockPos pos, BlockState state) {
        RENDER_CACHE.put(pos.immutable(), state);
    }

    public static void unregisterOverlay(BlockPos pos) {
        RENDER_CACHE.remove(pos);
    }

    public static void clearAllOverlays() {
        RENDER_CACHE.clear();
    }

    public static void forceRefresh() {
        lastFullRefreshTime = System.currentTimeMillis();
        UnderlayRenderer.clearAllOverlays();
        Minecraft client = Minecraft.getInstance();
        if (client.level != null && client.player != null) {
            BlockPos playerPos = client.player.blockPosition();
            int radius = 64;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -16; y <= 16; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos pos = playerPos.offset(x, y, z);
                        if (!UnderlayManagerClient.hasOverlay(pos)) continue;
                        UnderlayRenderer.registerOverlay(pos, UnderlayManagerClient.getOverlay(pos));
                    }
                }
            }
        }
    }

    private static void checkForFullRefresh() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastFullRefreshTime > 500L) {
            UnderlayRenderer.forceRefresh();
        }
    }

    private static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        BlockRenderDispatcher blockRenderer = client.getBlockRenderer();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 cameraPos = client.gameRenderer.getMainCamera().getPosition();
        RandomSource randomSource = RandomSource.create();
        RandomSource renderTypeRandom = RandomSource.create();
        HashSet<RenderType> usedRenderTypes = new HashSet<RenderType>();
        if (bufferSource == null || client.level == null || client.player == null) {
            return;
        }
        UnderlayRenderer.checkForFullRefresh();
        poseStack.pushPose();
        for (Map.Entry<BlockPos, BlockState> entry : RENDER_CACHE.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            int chunks = (Integer)client.options.renderDistance().get();
            int blocks = chunks * 16;
            double maxDistSq = (double)blocks * (double)blocks;
            double distanceSq = pos.distSqr((Vec3i)client.player.blockPosition());
            if (distanceSq > maxDistSq) continue;
            if (!UnderlayManagerClient.hasOverlay(pos)) {
                RENDER_CACHE.remove(pos);
                continue;
            }
            poseStack.pushPose();
            poseStack.translate((double)pos.getX() - cameraPos.x, (double)pos.getY() - cameraPos.y, (double)pos.getZ() - cameraPos.z);
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.scale(1.0001f, 1.0001f, 1.0001f);
            poseStack.translate(-0.5, -0.5, -0.5);
            BakedModel model = blockRenderer.getBlockModel(state);
            ModelData modelData = ModelData.EMPTY;
            renderTypeRandom.setSeed(42L);
            for (RenderType chunkRenderType : model.getRenderTypes(state, renderTypeRandom, modelData)) {
                RenderType movingRenderType = RenderTypeHelper.getMovingBlockRenderType((RenderType)chunkRenderType);
                VertexConsumer vertexConsumer = bufferSource.getBuffer(movingRenderType);
                blockRenderer.renderBatched(state, pos, (BlockAndTintGetter)client.level, poseStack, vertexConsumer, false, randomSource, modelData, chunkRenderType);
                usedRenderTypes.add(movingRenderType);
            }
            poseStack.popPose();
        }
        for (RenderType usedType : usedRenderTypes) {
            bufferSource.endBatch(usedType);
        }
        poseStack.popPose();
    }
}

