/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main;

import com.dooji.underlay.main.Underlay;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelResource;

public class UnderlayPersistenceHandler {
    private static final int MAX_OVERLAY_SAVE_ATTEMPTS = 3;

    private static String getSaveFileName(Level world) {
        String dimensionId = world.dimension().location().toString();
        if ("minecraft:overworld".equals(dimensionId)) {
            return "underlays.dat";
        }
        return "underlays_" + dimensionId.replace(':', '_') + ".dat";
    }

    public static void saveOverlays(Level world, Map<BlockPos, BlockState> overlays) {
        if (world == null || overlays == null) {
            Underlay.LOGGER.warn("Attempted to save overlays with null parameters");
            return;
        }
        if (world.isClientSide() || !(world instanceof ServerLevel)) {
            return;
        }
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                CompoundTag rootTag = new CompoundTag();
                ListTag overlayList = new ListTag();
                for (Map.Entry<BlockPos, BlockState> entry : overlays.entrySet()) {
                    BlockPos pos = entry.getKey();
                    BlockState state = entry.getValue();
                    CompoundTag overlayTag = new CompoundTag();
                    overlayTag.putInt("x", pos.getX());
                    overlayTag.putInt("y", pos.getY());
                    overlayTag.putInt("z", pos.getZ());
                    overlayTag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)state));
                    overlayList.add((Object)overlayTag);
                }
                rootTag.put("overlays", (Tag)overlayList);
                ServerLevel serverWorld = (ServerLevel)world;
                Path saveDir = serverWorld.getServer().getWorldPath(LevelResource.ROOT).resolve("data");
                String fileName = UnderlayPersistenceHandler.getSaveFileName(world);
                File saveFile = saveDir.resolve(fileName).toFile();
                saveDir.toFile().mkdirs();
                try (FileOutputStream fos = new FileOutputStream(saveFile);){
                    NbtIo.writeCompressed((CompoundTag)rootTag, (OutputStream)fos);
                    break;
                }
            }
            catch (IOException e) {
                Underlay.LOGGER.error("Failed to save overlays (Attempt " + (attempt + 1) + ")", (Throwable)e);
                try {
                    Thread.sleep(100 * (attempt + 1));
                    continue;
                }
                catch (InterruptedException ie) {
                    Underlay.LOGGER.warn("Overlay save interrupted", (Throwable)ie);
                    break;
                }
            }
        }
    }

    public static Map<BlockPos, BlockState> loadOverlays(Level world) {
        HashMap<BlockPos, BlockState> overlays;
        block14: {
            overlays = new HashMap<BlockPos, BlockState>();
            if (world == null) {
                Underlay.LOGGER.warn("Attempted to load overlays with null world");
                return overlays;
            }
            if (world.isClientSide() || !(world instanceof ServerLevel)) {
                return overlays;
            }
            try {
                ServerLevel serverWorld = (ServerLevel)world;
                Path saveDir = serverWorld.getServer().getWorldPath(LevelResource.ROOT).resolve("data");
                String fileName = UnderlayPersistenceHandler.getSaveFileName(world);
                File saveFile = saveDir.resolve(fileName).toFile();
                if (!saveFile.exists()) {
                    Underlay.LOGGER.info("No existing overlay save file found");
                    return overlays;
                }
                try (FileInputStream fis = new FileInputStream(saveFile);){
                    CompoundTag rootTag = NbtIo.readCompressed((InputStream)fis, (NbtAccounter)NbtAccounter.unlimitedHeap());
                    if (!rootTag.contains("overlays")) break block14;
                    ListTag overlayList = rootTag.getList("overlays", 10);
                    for (int i = 0; i < overlayList.size(); ++i) {
                        CompoundTag overlayTag = overlayList.getCompound(i);
                        int x = overlayTag.getInt("x");
                        int y = overlayTag.getInt("y");
                        int z = overlayTag.getInt("z");
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = null;
                        if (overlayTag.contains("state")) {
                            try {
                                CompoundTag stateTag = overlayTag.getCompound("state");
                                state = NbtUtils.readBlockState((HolderGetter)serverWorld.holderLookup(Registries.BLOCK), (CompoundTag)stateTag);
                            }
                            catch (Exception e) {
                                Underlay.LOGGER.warn("Failed to read block state from NBT", (Throwable)e);
                            }
                        }
                        if (state == null) continue;
                        overlays.put(pos, state);
                    }
                    Underlay.LOGGER.info("Loaded " + overlays.size() + " overlays");
                }
            }
            catch (IOException e) {
                Underlay.LOGGER.error("Failed to load overlays", (Throwable)e);
            }
        }
        return overlays;
    }
}

