/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.universalgrid.neoforge;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.content.RegistryCallback;
import com.refinedmods.refinedstorage.common.support.packet.PacketHandler;
import com.refinedmods.refinedstorage.neoforge.support.energy.EnergyStorageAdapter;
import com.ultramega.universalgrid.common.AbstractModInitializer;
import com.ultramega.universalgrid.common.ContentIds;
import com.ultramega.universalgrid.common.Platform;
import com.ultramega.universalgrid.common.packet.c2s.SetCursorPosStackPacket;
import com.ultramega.universalgrid.common.packet.c2s.UpdateDisabledSlotPacket;
import com.ultramega.universalgrid.common.packet.c2s.UseUniversalGridOnServerPacket;
import com.ultramega.universalgrid.common.packet.s2c.SetCursorPosWindowPacket;
import com.ultramega.universalgrid.common.packet.s2c.SetDisabledSlotPacket;
import com.ultramega.universalgrid.common.packet.s2c.UseUniversalGridOnClientPacket;
import com.ultramega.universalgrid.common.registry.CreativeModeTabItems;
import com.ultramega.universalgrid.common.registry.Items;
import com.ultramega.universalgrid.common.wirelessuniversalgrid.WirelessUniversalGridItem;
import com.ultramega.universalgrid.neoforge.ClientModInitializer;
import com.ultramega.universalgrid.neoforge.ConfigImpl;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="universalgrid")
public class ModInitializer
extends AbstractModInitializer {
    private final DeferredRegister<Item> itemRegistry = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"universalgrid");
    private final DeferredRegister<DataComponentType<?>> dataComponentTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"universalgrid");

    public ModInitializer(IEventBus eventBus, ModContainer modContainer) {
        ConfigImpl config = new ConfigImpl();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config.getSpec());
        Platform.setConfigProvider(() -> config);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            eventBus.addListener(ClientModInitializer::onClientSetup);
            eventBus.addListener(ClientModInitializer::onRegisterKeyMappings);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        this.registerContent(eventBus);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::registerPackets);
        eventBus.addListener(this::registerCreativeModeTabListener);
    }

    private void registerContent(IEventBus eventBus) {
        this.registerItems(eventBus);
        this.registerDataComponents(eventBus);
    }

    private void registerItems(IEventBus eventBus) {
        ForgeRegistryCallback<Item> callback = new ForgeRegistryCallback<Item>(this.itemRegistry);
        this.registerCustomItems(callback);
        this.itemRegistry.register(eventBus);
    }

    private void registerCustomItems(RegistryCallback<Item> callback) {
        Items.INSTANCE.setWirelessUniversalGrid(callback.register(ContentIds.WIRELESS_UNIVERSAL_GRID, () -> new WirelessUniversalGridItem(this, false, RefinedStorageApi.INSTANCE.getEnergyItemHelper(), RefinedStorageApi.INSTANCE.getNetworkItemHelper()){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
        Items.INSTANCE.setCreativeWirelessUniversalGrid(callback.register(ContentIds.CREATIVE_WIRELESS_UNIVERSAL_GRID, () -> new WirelessUniversalGridItem(this, true, RefinedStorageApi.INSTANCE.getEnergyItemHelper(), RefinedStorageApi.INSTANCE.getNetworkItemHelper()){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
    }

    private void registerDataComponents(IEventBus eventBus) {
        ForgeRegistryCallback callback = new ForgeRegistryCallback(this.dataComponentTypeRegistry);
        this.registerDataComponents(callback);
        this.dataComponentTypeRegistry.register(eventBus);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        this.registerEnergyItemProviders(event);
    }

    private void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("universalgrid");
        registrar.playToServer(SetCursorPosStackPacket.PACKET_TYPE, SetCursorPosStackPacket.STREAM_CODEC, ModInitializer.wrapHandler(SetCursorPosStackPacket::handle));
        registrar.playToServer(UpdateDisabledSlotPacket.PACKET_TYPE, UpdateDisabledSlotPacket.STREAM_CODEC, ModInitializer.wrapHandler(UpdateDisabledSlotPacket::handle));
        registrar.playToServer(UseUniversalGridOnServerPacket.PACKET_TYPE, UseUniversalGridOnServerPacket.STREAM_CODEC, ModInitializer.wrapHandler(UseUniversalGridOnServerPacket::handle));
        registrar.playToClient(SetCursorPosWindowPacket.PACKET_TYPE, SetCursorPosWindowPacket.STREAM_CODEC, ModInitializer.wrapHandler(SetCursorPosWindowPacket::handle));
        registrar.playToClient(SetDisabledSlotPacket.PACKET_TYPE, SetDisabledSlotPacket.STREAM_CODEC, ModInitializer.wrapHandler(SetDisabledSlotPacket::handle));
        registrar.playToClient(UseUniversalGridOnClientPacket.PACKET_TYPE, UseUniversalGridOnClientPacket.STREAM_CODEC, ModInitializer.wrapHandler(UseUniversalGridOnClientPacket::handle));
    }

    private void registerEnergyItemProviders(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> new EnergyStorageAdapter(Items.INSTANCE.getWirelessUniversalGrid().createEnergyStorage((ItemStack)stack)), new ItemLike[]{Items.INSTANCE.getWirelessUniversalGrid()});
    }

    private void registerCreativeModeTabListener(BuildCreativeModeTabContentsEvent e) {
        ResourceKey creativeModeTab = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)RefinedStorageApi.INSTANCE.getCreativeModeTabId());
        if (!e.getTabKey().equals(creativeModeTab)) {
            return;
        }
        CreativeModeTabItems.addItems(arg_0 -> ((BuildCreativeModeTabContentsEvent)e).accept(arg_0));
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> wrapHandler(PacketHandler<T> handler) {
        return (packet, ctx) -> handler.handle((Object)packet, () -> ((IPayloadContext)ctx).player());
    }

    private record ForgeRegistryCallback<T>(DeferredRegister<T> registry) implements RegistryCallback<T>
    {
        public <R extends T> Supplier<R> register(ResourceLocation id, Supplier<R> value) {
            return this.registry.register(id.getPath(), value);
        }
    }
}

