/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block;

import cy.jdkdigital.utilitarian.Utilitarian;
import cy.jdkdigital.utilitarian.common.entity.RisingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class MagnetBlock
extends Block {
    public MagnetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.ENABLED});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.checkPoweredState(level, pos, state, 2);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state, int flags) {
        boolean noSignal;
        boolean bl = noSignal = !level.hasNeighborSignal(pos);
        if (noSignal != (Boolean)state.getValue((Property)BlockStateProperties.ENABLED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(noSignal)), flags);
            if (noSignal) {
                level.getEntitiesOfClass(RisingBlockEntity.class, new AABB(pos).setMinY((double)(pos.getY() - 10))).forEach(risingBlockEntity -> {
                    FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)level, (BlockPos)risingBlockEntity.blockPosition(), (BlockState)risingBlockEntity.blockState);
                    Block patt0$temp = risingBlockEntity.blockState.getBlock();
                    if (patt0$temp instanceof FallingBlock) {
                        FallingBlock fallingBlock = (FallingBlock)patt0$temp;
                        fallingBlock.falling(fallingBlockEntity);
                    }
                    risingBlockEntity.discard();
                });
            } else {
                level.getEntitiesOfClass(FallingBlockEntity.class, new AABB(pos).setMinY((double)(pos.getY() - 10))).forEach(fallingBlockEntity -> {
                    RisingBlockEntity.rise(level, fallingBlockEntity.blockPosition(), fallingBlockEntity.blockState);
                    fallingBlockEntity.discard();
                });
                for (int i = 1; i < 10; ++i) {
                    BlockState stateBelow = level.getBlockState(pos.below(i));
                    if (stateBelow.is(Utilitarian.MAGNET_VALID_BLOCKS)) {
                        RisingBlockEntity.rise(level, pos.below(i), stateBelow);
                        break;
                    }
                    if (!stateBelow.isAir()) break;
                }
            }
        }
    }
}

