/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.drex.villagerconfig.common.data.TradeTier;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;

public class TradeTable {
    public static final Codec<TradeTable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TradeTier.CODEC.listOf().fieldOf("tiers").forGetter(tradeTable -> tradeTable.tiers)).apply((Applicative)instance, TradeTable::new));
    final List<TradeTier> tiers;

    public TradeTable(List<TradeTier> tiers) {
        this.tiers = tiers;
    }

    private TradeTier getTradeTier(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("Villager level must at least be 1");
        }
        if (this.tiers.size() >= level) {
            return this.tiers.get(level - 1);
        }
        return TradeTier.EMPTY;
    }

    public VillagerTrades.ItemListing[] getTradeOffers(AbstractVillager villager, int level) {
        TradeTier tradeTier = this.getTradeTier(level);
        return tradeTier.getTradeOffers(villager);
    }

    public int requiredExperience(int level) {
        return this.getTradeTier(level).requiredExperience();
    }

    public int maxLevel() {
        return this.tiers.size();
    }
}

