/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util.loot.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.drex.villagerconfig.common.util.loot.LootItemFunctionTypes;
import me.drex.villagerconfig.common.util.loot.VCLootContextParams;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class EnchantRandomlyLootFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<EnchantRandomlyLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> EnchantRandomlyLootFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).optionalFieldOf("include").forGetter(enchantRandomlyFunction -> enchantRandomlyFunction.include), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).optionalFieldOf("exclude").forGetter(enchantRandomlyFunction -> enchantRandomlyFunction.exclude), (App)Codec.INT.optionalFieldOf("min_level", (Object)0).forGetter(enchantRandomlyLootFunction -> enchantRandomlyLootFunction.minLevel), (App)Codec.INT.optionalFieldOf("max_level", (Object)Integer.MAX_VALUE).forGetter(enchantRandomlyLootFunction -> enchantRandomlyLootFunction.maxLevel))).apply((Applicative)instance, EnchantRandomlyLootFunction::new));
    private final Optional<HolderSet<Enchantment>> include;
    private final Optional<HolderSet<Enchantment>> exclude;
    private final int minLevel;
    private final int maxLevel;

    EnchantRandomlyLootFunction(List<LootItemCondition> conditions, Optional<HolderSet<Enchantment>> include, Optional<HolderSet<Enchantment>> exclude, int minLevel, int maxLevel) {
        super(conditions);
        this.include = include;
        this.exclude = exclude;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack stack, LootContext context) {
        RandomSource randomSource = context.getRandom();
        Optional optional = this.include.flatMap(holders -> holders.getRandomElement(randomSource)).or(() -> {
            boolean isBook = stack.is(Items.BOOK);
            HolderSet<Enchantment> excluded = this.exclude.orElse((HolderSet<Enchantment>)HolderSet.direct((Holder[])new Holder[0]));
            List<Holder.Reference> list = context.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(reference -> isBook || ((Enchantment)reference.value()).canEnchant(stack)).filter(reference -> !excluded.contains((Holder)reference)).toList();
            return Util.getRandomSafe(list, (RandomSource)randomSource);
        });
        if (optional.isEmpty()) {
            LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)stack);
            return stack;
        }
        return this.enchantItem(stack, (Holder<Enchantment>)((Holder)optional.get()), randomSource, context);
    }

    private ItemStack enchantItem(ItemStack itemStack, Holder<Enchantment> holder, RandomSource randomSource, LootContext context) {
        Enchantment enchantment = (Enchantment)holder.value();
        int level = Mth.nextInt((RandomSource)randomSource, (int)enchantment.getMinLevel(), (int)enchantment.getMaxLevel());
        level = Mth.clamp((int)level, (int)this.minLevel, (int)this.maxLevel);
        if (itemStack.is(Items.BOOK)) {
            itemStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        }
        itemStack.enchant(holder, level);
        if (context.hasParam(VCLootContextParams.NUMBER_REFERENCE)) {
            Map referenceProviders = (Map)context.getParam(VCLootContextParams.NUMBER_REFERENCE);
            referenceProviders.put("enchantmentLevel", Float.valueOf(level));
            referenceProviders.put("treasureMultiplier", Float.valueOf(holder.is(EnchantmentTags.DOUBLE_TRADE_PRICE) ? 2.0f : 1.0f));
        }
        return itemStack;
    }

    @NotNull
    public LootItemFunctionType getType() {
        return LootItemFunctionTypes.ENCHANT_RANDOMLY;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private Optional<HolderSet<Enchantment>> include = Optional.empty();
        private Optional<HolderSet<Enchantment>> exclude = Optional.empty();
        private int minLevel = 0;
        private int maxLevel = Integer.MAX_VALUE;

        public Builder include(HolderSet<Enchantment> enchantments) {
            this.include = Optional.of(enchantments);
            return this;
        }

        public Builder exclude(HolderSet<Enchantment> enchantments) {
            this.exclude = Optional.of(enchantments);
            return this;
        }

        public Builder minLevel(int minLevel) {
            this.minLevel = minLevel;
            return this;
        }

        public Builder maxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        @NotNull
        public LootItemFunction build() {
            return new EnchantRandomlyLootFunction(this.getConditions(), this.include, this.exclude, this.minLevel, this.maxLevel);
        }

        @NotNull
        protected Builder getThis() {
            return this;
        }
    }
}

