/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.shadow.fablabsmc.fablabs.impl.fiber.annotation.collect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.annotation.Listener;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.annotation.Setting;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.annotation.Settings;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.annotation.collect.MemberCollector;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.annotation.collect.PojoMemberProcessor;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.exception.ProcessingMemberException;

public class MemberCollectorImpl
implements MemberCollector {
    private final boolean onlyAnnotated;

    public MemberCollectorImpl(boolean onlyAnnotated) {
        this.onlyAnnotated = onlyAnnotated;
    }

    private boolean isIncluded(Member member) {
        if (member.isSynthetic() || Modifier.isTransient(member.getModifiers())) {
            return false;
        }
        boolean onlyAnnotated = this.onlyAnnotated;
        Class<?> owningClass = member.getDeclaringClass();
        if (owningClass.isAnnotationPresent(Settings.class)) {
            onlyAnnotated = owningClass.getAnnotation(Settings.class).onlyAnnotated();
        }
        if (member instanceof AccessibleObject) {
            AccessibleObject object = (AccessibleObject)((Object)member);
            if (object.isAnnotationPresent(Setting.class)) {
                return !object.getAnnotation(Setting.class).ignore();
            }
            return object.isAnnotationPresent(Listener.class) || !onlyAnnotated;
        }
        return false;
    }

    @Override
    public <P> void collect(P pojo, Class<? super P> clazz, PojoMemberProcessor processor) throws ProcessingMemberException {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!this.isIncluded(method) || !method.isAnnotationPresent(Listener.class)) continue;
            processor.processListenerMethod(pojo, method, method.getAnnotation(Listener.class).value());
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            if (!this.isIncluded((Member)((Object)accessibleObject)) || !accessibleObject.isAnnotationPresent(Listener.class)) continue;
            processor.processListenerField(pojo, (Field)accessibleObject, ((Field)accessibleObject).getAnnotation(Listener.class).value());
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            if (!this.isIncluded((Member)((Object)accessibleObject)) || accessibleObject.isAnnotationPresent(Listener.class)) continue;
            if (accessibleObject.isAnnotationPresent(Setting.Group.class)) {
                processor.processGroup(pojo, (Field)accessibleObject);
                continue;
            }
            processor.processSetting(pojo, (Field)accessibleObject);
        }
    }
}

