/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import com.google.gson.JsonObject;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.XNet;
import mcjty.xnet.apiimpl.ConnectedBlock;
import mcjty.xnet.apiimpl.ConnectedEntity;
import mcjty.xnet.apiimpl.logic.ConnectedOptionalEntity;
import mcjty.xnet.apiimpl.logic.LogicConnectorSettings;
import mcjty.xnet.apiimpl.logic.RSOutput;
import mcjty.xnet.apiimpl.logic.RSSensor;
import mcjty.xnet.apiimpl.logic.enums.LogicMode;
import mcjty.xnet.logic.LogicOperations;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LogicChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)"textures/gui/guielements.png");
    private int colors = 0;
    private List<ConnectedOptionalEntity<LogicConnectorSettings>> sensors = null;
    private List<ConnectedBlock<LogicConnectorSettings>> outputs = null;
    public static final MapCodec<LogicChannelSettings> CODEC = MapCodec.unit(LogicChannelSettings::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, LogicChannelSettings> STREAM_CODEC = StreamCodec.of((buf, settings) -> {}, buf -> new LogicChannelSettings());

    public IChannelType getType() {
        return XNet.setup.logicChannelType;
    }

    public JsonObject writeToJson() {
        return new JsonObject();
    }

    public void readFromJson(JsonObject data) {
    }

    public void readFromNBT(CompoundTag tag) {
        this.colors = tag.getInt("colors");
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putInt("colors", this.colors);
    }

    public int getColors() {
        return this.colors;
    }

    public void tick(int channel, IControllerContext context) {
        LogicConnectorSettings settings;
        this.updateCache(channel, context);
        Level world = context.getControllerWorld();
        this.colors = 0;
        for (ConnectedOptionalEntity<LogicConnectorSettings> connectedOptionalEntity : this.sensors) {
            settings = (LogicConnectorSettings)((Object)connectedOptionalEntity.settings());
            int sensorColors = 0;
            BlockPos pos = connectedOptionalEntity.getBlockPos();
            if (!LevelTools.isLoaded((Level)world, (BlockPos)pos)) {
                this.colors |= settings.getColorMask();
                continue;
            }
            if (this.checkRedstone(settings, connectedOptionalEntity.getConnectorEntity(), context)) {
                BlockEntity te = connectedOptionalEntity.getConnectedEntity();
                for (RSSensor sensor : settings.getSensors()) {
                    if (!sensor.test(te, world, pos, settings)) continue;
                    sensorColors |= 1 << sensor.getOutputColor().ordinal();
                }
            }
            settings.setColorMask(sensorColors);
            this.colors |= sensorColors;
        }
        for (ConnectedBlock connectedBlock : this.outputs) {
            boolean input2;
            boolean[] colorsArray;
            boolean input1;
            RSOutput output;
            settings = (LogicConnectorSettings)((Object)connectedBlock.settings());
            BlockPos connectorPos = connectedBlock.connectorPos();
            if (!LevelTools.isLoaded((Level)world, (BlockPos)connectorPos)) continue;
            Direction side = connectedBlock.sidedConsumer().side();
            ConnectorTileEntity connectorTileEntity = connectedBlock.getConnectorEntity();
            int powerOut = this.checkRedstone(settings, connectorTileEntity, context) ? (LogicOperations.applyFilter(output = settings.getOutput(), input1 = (colorsArray = LogicTools.intToBinary(this.colors))[output.getInputChannel1().ordinal()], input2 = colorsArray[output.getInputChannel2().ordinal()]) ? output.getRedstoneOut() : 0) : 0;
            connectorTileEntity.setPowerOut(side, powerOut);
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.sensors == null) {
            ConnectedBlock<LogicConnectorSettings> connectedBlock;
            LogicConnectorSettings con;
            this.sensors = new ArrayList<ConnectedOptionalEntity<LogicConnectorSettings>>();
            this.outputs = new ArrayList<ConnectedBlock<LogicConnectorSettings>>();
            Level world = context.getControllerWorld();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                connectedBlock = this.getConnectedBlockInfo(context, entry, world, con = (LogicConnectorSettings)((Object)entry.getValue()));
                if (connectedBlock == null) continue;
                if (con.getLogicMode() == LogicMode.SENSOR) {
                    ConnectedOptionalEntity<LogicConnectorSettings> connectedEntity = this.getConnectedEntity(connectedBlock, world);
                    this.sensors.add(connectedEntity);
                    continue;
                }
                this.outputs.add(connectedBlock);
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (LogicConnectorSettings)((Object)entry.getValue());
                if (con.getLogicMode() != LogicMode.OUTPUT || (connectedBlock = this.getConnectedBlockInfo(context, entry, world, con)) == null) continue;
                this.outputs.add(connectedBlock);
            }
        }
    }

    @Nonnull
    private ConnectedOptionalEntity<LogicConnectorSettings> getConnectedEntity(@Nonnull ConnectedBlock<LogicConnectorSettings> connectedBlock, @Nonnull Level world) {
        BlockEntity connectedEntity = world.getBlockEntity(connectedBlock.getBlockPos());
        return new ConnectedOptionalEntity<LogicConnectorSettings>(connectedBlock, connectedEntity);
    }

    @Nullable
    private ConnectedBlock<LogicConnectorSettings> getConnectedBlockInfo(IControllerContext context, Map.Entry<SidedConsumer, IConnectorSettings> entry, @Nonnull Level world, @Nonnull LogicConnectorSettings con) {
        BlockPos connectorPos = context.findConsumerPosition(entry.getKey().consumerId());
        if (connectorPos == null) {
            return null;
        }
        ConnectorTileEntity connectorEntity = (ConnectorTileEntity)world.getBlockEntity(connectorPos);
        if (connectorEntity == null) {
            return null;
        }
        BlockPos connectedBlockPos = connectorPos.relative(entry.getKey().side());
        BlockEntity connectedEntity = world.getBlockEntity(connectedBlockPos);
        if (connectedEntity == null) {
            return new ConnectedBlock<LogicConnectorSettings>(entry.getKey(), con, connectorPos, connectedBlockPos, connectorEntity);
        }
        return new ConnectedEntity<LogicConnectorSettings>(entry.getKey(), con, connectorPos, connectedBlockPos, connectedEntity, connectorEntity);
    }

    public void cleanCache() {
        this.sensors = null;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 11, 90, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    public void createGui(IEditorGui gui) {
    }

    public void update(Map<String, Object> data) {
    }
}

