/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.xnet.compat.XNetTOPDriver;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public abstract class GenericCableBlock
extends Block
implements TOPInfoProvider,
SimpleWaterloggedBlock {
    public static final EnumProperty<ConnectorType> NORTH = EnumProperty.create((String)"north", ConnectorType.class);
    public static final EnumProperty<ConnectorType> SOUTH = EnumProperty.create((String)"south", ConnectorType.class);
    public static final EnumProperty<ConnectorType> WEST = EnumProperty.create((String)"west", ConnectorType.class);
    public static final EnumProperty<ConnectorType> EAST = EnumProperty.create((String)"east", ConnectorType.class);
    public static final EnumProperty<ConnectorType> UP = EnumProperty.create((String)"up", ConnectorType.class);
    public static final EnumProperty<ConnectorType> DOWN = EnumProperty.create((String)"down", ConnectorType.class);
    public static final EnumProperty<CableColor> COLOR = EnumProperty.create((String)"color", CableColor.class);
    public static final ModelProperty<BlockState> FACADEID = new ModelProperty();
    private static VoxelShape[] shapeCache = null;
    private static final VoxelShape SHAPE_CABLE_NORTH = Shapes.box((double)0.4, (double)0.4, (double)0.0, (double)0.6, (double)0.6, (double)0.4);
    private static final VoxelShape SHAPE_CABLE_SOUTH = Shapes.box((double)0.4, (double)0.4, (double)0.6, (double)0.6, (double)0.6, (double)1.0);
    private static final VoxelShape SHAPE_CABLE_WEST = Shapes.box((double)0.0, (double)0.4, (double)0.4, (double)0.4, (double)0.6, (double)0.6);
    private static final VoxelShape SHAPE_CABLE_EAST = Shapes.box((double)0.6, (double)0.4, (double)0.4, (double)1.0, (double)0.6, (double)0.6);
    private static final VoxelShape SHAPE_CABLE_UP = Shapes.box((double)0.4, (double)0.6, (double)0.4, (double)0.6, (double)1.0, (double)0.6);
    private static final VoxelShape SHAPE_CABLE_DOWN = Shapes.box((double)0.4, (double)0.0, (double)0.4, (double)0.6, (double)0.4, (double)0.6);
    private static final VoxelShape SHAPE_BLOCK_NORTH = Shapes.box((double)0.2, (double)0.2, (double)0.0, (double)0.8, (double)0.8, (double)0.1);
    private static final VoxelShape SHAPE_BLOCK_SOUTH = Shapes.box((double)0.2, (double)0.2, (double)0.9, (double)0.8, (double)0.8, (double)1.0);
    private static final VoxelShape SHAPE_BLOCK_WEST = Shapes.box((double)0.0, (double)0.2, (double)0.2, (double)0.1, (double)0.8, (double)0.8);
    private static final VoxelShape SHAPE_BLOCK_EAST = Shapes.box((double)0.9, (double)0.2, (double)0.2, (double)1.0, (double)0.8, (double)0.8);
    private static final VoxelShape SHAPE_BLOCK_UP = Shapes.box((double)0.2, (double)0.9, (double)0.2, (double)0.8, (double)1.0, (double)0.8);
    private static final VoxelShape SHAPE_BLOCK_DOWN = Shapes.box((double)0.2, (double)0.0, (double)0.2, (double)0.8, (double)0.1, (double)0.8);
    private final CableBlockType type;

    public GenericCableBlock(CableBlockType type) {
        super(BlockBehaviour.Properties.of().strength(1.0f).sound(SoundType.METAL).noOcclusion());
        this.makeShapes();
        this.type = type;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private int calculateShapeIndex(ConnectorType north, ConnectorType south, ConnectorType west, ConnectorType east, ConnectorType up, ConnectorType down) {
        int l = ConnectorType.values().length;
        return ((((south.ordinal() * l + north.ordinal()) * l + west.ordinal()) * l + east.ordinal()) * l + up.ordinal()) * l + down.ordinal();
    }

    private void makeShapes() {
        if (shapeCache == null) {
            int length = ConnectorType.values().length;
            shapeCache = new VoxelShape[length * length * length * length * length * length];
            for (ConnectorType up : ConnectorType.VALUES) {
                for (ConnectorType down : ConnectorType.VALUES) {
                    for (ConnectorType north : ConnectorType.VALUES) {
                        for (ConnectorType south : ConnectorType.VALUES) {
                            for (ConnectorType east : ConnectorType.VALUES) {
                                for (ConnectorType west : ConnectorType.VALUES) {
                                    int idx = this.calculateShapeIndex(north, south, west, east, up, down);
                                    GenericCableBlock.shapeCache[idx] = this.makeShape(north, south, west, east, up, down);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private VoxelShape makeShape(ConnectorType north, ConnectorType south, ConnectorType west, ConnectorType east, ConnectorType up, ConnectorType down) {
        VoxelShape shape = Shapes.box((double)0.4, (double)0.4, (double)0.4, (double)0.6, (double)0.6, (double)0.6);
        shape = this.combineShape(shape, north, SHAPE_CABLE_NORTH, SHAPE_BLOCK_NORTH);
        shape = this.combineShape(shape, south, SHAPE_CABLE_SOUTH, SHAPE_BLOCK_SOUTH);
        shape = this.combineShape(shape, west, SHAPE_CABLE_WEST, SHAPE_BLOCK_WEST);
        shape = this.combineShape(shape, east, SHAPE_CABLE_EAST, SHAPE_BLOCK_EAST);
        shape = this.combineShape(shape, up, SHAPE_CABLE_UP, SHAPE_BLOCK_UP);
        shape = this.combineShape(shape, down, SHAPE_CABLE_DOWN, SHAPE_BLOCK_DOWN);
        return shape;
    }

    private VoxelShape combineShape(VoxelShape shape, ConnectorType connectorType, VoxelShape cableShape, VoxelShape blockShape) {
        if (connectorType == ConnectorType.CABLE) {
            return Shapes.join((VoxelShape)shape, (VoxelShape)cableShape, (BooleanOp)BooleanOp.OR);
        }
        if (connectorType == ConnectorType.BLOCK) {
            return Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.join((VoxelShape)blockShape, (VoxelShape)cableShape, (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    private Item getItem(CableColor color) {
        return switch (this.type.ordinal()) {
            case 0 -> {
                switch (color) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BLUE: {
                        yield (Item)CableModule.NETCABLE_BLUE.get();
                    }
                    case RED: {
                        yield (Item)CableModule.NETCABLE_RED.get();
                    }
                    case YELLOW: {
                        yield (Item)CableModule.NETCABLE_YELLOW.get();
                    }
                    case GREEN: {
                        yield (Item)CableModule.NETCABLE_GREEN.get();
                    }
                    case ROUTING: 
                }
                yield (Item)CableModule.NETCABLE_ROUTING.get();
            }
            case 1 -> {
                switch (color) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BLUE: {
                        yield (Item)CableModule.CONNECTOR_BLUE.get();
                    }
                    case RED: {
                        yield (Item)CableModule.CONNECTOR_RED.get();
                    }
                    case YELLOW: {
                        yield (Item)CableModule.CONNECTOR_YELLOW.get();
                    }
                    case GREEN: {
                        yield (Item)CableModule.CONNECTOR_GREEN.get();
                    }
                    case ROUTING: 
                }
                yield (Item)CableModule.CONNECTOR_ROUTING.get();
            }
            case 2 -> {
                switch (color) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BLUE: {
                        yield (Item)CableModule.ADVANCED_CONNECTOR_BLUE.get();
                    }
                    case RED: {
                        yield (Item)CableModule.ADVANCED_CONNECTOR_RED.get();
                    }
                    case YELLOW: {
                        yield (Item)CableModule.ADVANCED_CONNECTOR_YELLOW.get();
                    }
                    case GREEN: {
                        yield (Item)CableModule.ADVANCED_CONNECTOR_GREEN.get();
                    }
                    case ROUTING: 
                }
                yield (Item)CableModule.ADVANCED_CONNECTOR_ROUTING.get();
            }
            default -> Items.AIR;
        };
    }

    public ItemStack getCloneItemStack(LevelReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.getItem((CableColor)((Object)state.getValue(COLOR))));
    }

    @Nullable
    protected BlockState getMimicBlock(BlockGetter blockAccess, BlockPos pos) {
        BlockEntity te = blockAccess.getBlockEntity(pos);
        if (te instanceof IFacadeSupport) {
            return ((IFacadeSupport)te).getMimicBlock();
        }
        return null;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (this.getMimicBlock(world, pos) != null) {
            return this.getMimicBlock(world, pos).getShape(world, pos, context);
        }
        CableColor color = (CableColor)((Object)state.getValue(COLOR));
        ConnectorType north = this.getConnectorType(color, world, pos, Direction.NORTH);
        ConnectorType south = this.getConnectorType(color, world, pos, Direction.SOUTH);
        ConnectorType west = this.getConnectorType(color, world, pos, Direction.WEST);
        ConnectorType east = this.getConnectorType(color, world, pos, Direction.EAST);
        ConnectorType up = this.getConnectorType(color, world, pos, Direction.UP);
        ConnectorType down = this.getConnectorType(color, world, pos, Direction.DOWN);
        int index = this.calculateShapeIndex(north, south, west, east, up, down);
        return shapeCache[index];
    }

    public boolean isAdvancedConnector() {
        return false;
    }

    public void setPlacedBy(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        BlockState blockState;
        this.originalOnBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide) {
            this.createCableSegment(world, pos, stack);
        }
        if (state != (blockState = this.calculateState((LevelAccessor)world, pos, state))) {
            world.setBlockAndUpdate(pos, blockState);
        }
    }

    protected void originalOnBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
    }

    public void createCableSegment(Level world, BlockPos pos, ItemStack stack) {
        XNetBlobData blobData = XNetBlobData.get(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        CableColor color = (CableColor)((Object)world.getBlockState(pos).getValue(COLOR));
        worldBlob.createCableSegment(pos, new ColorId(color.ordinal() + 1));
        blobData.save();
    }

    public void onRemove(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.getBlock() != state.getBlock() && !(newState.getBlock() instanceof GenericCableBlock)) {
            this.unlinkBlock(world, pos);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public void unlinkBlock(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED, COLOR, NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return super.getDrops(state, builder);
    }

    @Nonnull
    public BlockState updateShape(BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighbourState, @Nonnull LevelAccessor world, @Nonnull BlockPos current, @Nonnull BlockPos offset) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.getFluidTicks().schedule(new ScheduledTick((Object)Fluids.WATER, current, (long)Fluids.WATER.getTickDelay((LevelReader)world), 0L));
        }
        return this.calculateState(world, current, state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return (BlockState)this.calculateState((LevelAccessor)world, pos, this.defaultBlockState()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
    }

    @Nonnull
    public BlockState calculateState(LevelAccessor world, BlockPos pos, BlockState state) {
        CableColor color = (CableColor)((Object)state.getValue(COLOR));
        ConnectorType north = this.getConnectorType(color, (BlockGetter)world, pos, Direction.NORTH);
        ConnectorType south = this.getConnectorType(color, (BlockGetter)world, pos, Direction.SOUTH);
        ConnectorType west = this.getConnectorType(color, (BlockGetter)world, pos, Direction.WEST);
        ConnectorType east = this.getConnectorType(color, (BlockGetter)world, pos, Direction.EAST);
        ConnectorType up = this.getConnectorType(color, (BlockGetter)world, pos, Direction.UP);
        ConnectorType down = this.getConnectorType(color, (BlockGetter)world, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)north))).setValue(SOUTH, (Comparable)((Object)south))).setValue(WEST, (Comparable)((Object)west))).setValue(EAST, (Comparable)((Object)east))).setValue(UP, (Comparable)((Object)up))).setValue(DOWN, (Comparable)((Object)down));
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected abstract ConnectorType getConnectorType(@Nonnull CableColor var1, BlockGetter var2, BlockPos var3, Direction var4);

    public TOPDriver getProbeDriver() {
        return XNetTOPDriver.DRIVER;
    }

    public static enum CableBlockType {
        CABLE,
        CONNECTOR,
        ADVANCED_CONNECTOR,
        FACADE;

    }
}

