/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.xnet.utils.I18nConstants;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import terrails.xnetgases.module.ChemicalMatcher;
import terrails.xnetgases.module.logic.ChemicalLogicConnectorSettings;
import terrails.xnetgases.module.logic.enums.SensorMode;
import terrails.xnetgases.module.logic.enums.SensorOperator;

public class ChemicalSensor {
    public static final Codec<ChemicalSensor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("index").forGetter(s -> s.index), (App)SensorMode.CODEC.fieldOf("sensorMode").forGetter(ChemicalSensor::getSensorMode), (App)SensorOperator.CODEC.fieldOf("operator").forGetter(ChemicalSensor::getOperator), (App)Codec.INT.fieldOf("amount").forGetter(ChemicalSensor::getAmount), (App)Color.CODEC.fieldOf("outputColor").forGetter(ChemicalSensor::getOutputColor), (App)ItemStack.OPTIONAL_CODEC.fieldOf("filter").forGetter(s -> s.matcher.getStack())).apply((Applicative)instance, ChemicalSensor::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalSensor> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, s -> s.index, SensorMode.STREAM_CODEC, ChemicalSensor::getSensorMode, SensorOperator.STREAM_CODEC, ChemicalSensor::getOperator, (StreamCodec)ByteBufCodecs.INT, ChemicalSensor::getAmount, (StreamCodec)Color.STREAM_CODEC, ChemicalSensor::getOutputColor, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, s -> s.matcher.getStack(), ChemicalSensor::new);
    private final String modeTag;
    private final String operatorTag;
    private final String amountTag;
    private final String colorTag;
    private final String filterTag;
    private final int index;
    private SensorMode sensorMode = SensorMode.OFF;
    private SensorOperator operator = SensorOperator.EQUAL;
    private int amount = 0;
    private Color outputColor = Color.OFF;
    private ChemicalMatcher matcher = ChemicalMatcher.EMPTY;

    public ChemicalSensor(int index) {
        this.index = index;
        String temp = String.format("sensor%s_", index);
        this.modeTag = temp + "mode";
        this.operatorTag = temp + "operator";
        this.amountTag = temp + "amount";
        this.colorTag = temp + "scolor";
        this.filterTag = temp + "filter";
    }

    public ChemicalSensor(int index, SensorMode sensorMode, SensorOperator operator, int amount, Color outputColor, ItemStack filter) {
        this(index);
        this.sensorMode = sensorMode;
        this.operator = operator;
        this.amount = amount;
        this.outputColor = outputColor;
        this.matcher = ChemicalMatcher.from(filter);
    }

    public SensorMode getSensorMode() {
        return this.sensorMode;
    }

    public void setSensorMode(SensorMode sensorMode) {
        this.sensorMode = sensorMode;
    }

    public SensorOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SensorOperator operator) {
        this.operator = operator;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public Color getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(Color outputColor) {
        this.outputColor = outputColor;
    }

    public ChemicalMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(ChemicalMatcher matcher) {
        this.matcher = matcher;
    }

    public void createGui(IEditorGui gui) {
        gui.translatableChoices(this.modeTag, (ITranslatableEnum)this.getSensorMode(), (ITranslatableEnum[])SensorMode.values()).translatableChoices(this.operatorTag, (ITranslatableEnum)this.getOperator(), (ITranslatableEnum[])SensorOperator.values()).integer(this.amountTag, I18nConstants.LOGIC_SENSOR_AMOUNT_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.getAmount()), 46).colors(this.colorTag, I18nConstants.LOGIC_SENSOR_OUT_COLOR_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.getOutputColor().getColor()), Color.COLORS).ghostSlot(this.filterTag, this.getMatcher().getStack()).nl();
    }

    public boolean isEnabled(String tag) {
        if (this.modeTag.equals(tag)) {
            return true;
        }
        if (this.operatorTag.equals(tag)) {
            return true;
        }
        if (this.amountTag.equals(tag)) {
            return true;
        }
        if (this.colorTag.equals(tag)) {
            return true;
        }
        if (this.filterTag.equals(tag)) {
            return this.getSensorMode() != SensorMode.OFF;
        }
        return false;
    }

    public void update(Map<String, Object> data) {
        this.sensorMode = Optional.ofNullable(data.get(this.modeTag)).map(o -> SensorMode.values()[(Integer)o]).orElse(SensorMode.OFF);
        this.operator = Optional.ofNullable(data.get(this.operatorTag)).map(o -> SensorOperator.values()[(Integer)o]).orElse(SensorOperator.EQUAL);
        this.amount = Optional.ofNullable(data.get(this.amountTag)).map(Integer.class::cast).orElse(0);
        this.outputColor = Optional.ofNullable(data.get(this.colorTag)).map(o -> Color.colorByValue((int)((Integer)o))).orElse(Color.OFF);
        this.matcher = Optional.ofNullable(data.get("filter")).map(ItemStack.class::cast).map(ChemicalMatcher::from).orElse(ChemicalMatcher.EMPTY);
    }

    public boolean test(@Nullable BlockEntity be, @Nonnull Level level, @Nonnull BlockPos pos, ChemicalLogicConnectorSettings settings) {
        if (this.getSensorMode() == SensorMode.OFF) {
            return false;
        }
        IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapabilityIfLoaded(level, pos, null, be, settings.getFacing());
        if (handler == null) {
            return false;
        }
        return this.getOperator().match(this.getMatcher().amountInTank(handler, settings.getFacing()), this.getAmount());
    }
}

