/*
 * Decompiled with CFR 0.152.
 */
package com.mcdart.xp_synthesiser.blocks;

import com.mcdart.xp_synthesiser.XPSynthesiser;
import com.mcdart.xp_synthesiser.blocks.XPSynthesiserBlockEntity;
import com.mcdart.xp_synthesiser.items.KillRecorderItem;
import com.mcdart.xp_synthesiser.util.HelperFunctions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class SynthesiserMenu
extends AbstractContainerMenu {
    public static final int HOTBAR_XPOS = 8;
    public static final int HOTBAR_YPOS = 142;
    public static final int PLAYER_INVENTORY_XPOS = 8;
    public static final int PLAYER_INVENTORY_YPOS = 84;
    public static final int RECORDER_SLOT_XPOS = 80;
    public static final int RECORDER_SLOT_YPOS = 38;
    public static final int SLOT_X_SPACING = 18;
    public static final int SLOT_Y_SPACING = 18;
    public static final int INVENTORY_SLOTS = 36;
    private final XPSynthesiserBlockEntity synthesiser;

    public SynthesiserMenu(int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        this(windowId, invPlayer, extraData.readBlockPos());
    }

    public SynthesiserMenu(int windowId, Inventory invPlayer, BlockPos pos) {
        super(XPSynthesiser.SYNTHESISER_MENU.get(), windowId);
        this.synthesiser = (XPSynthesiserBlockEntity)((Object)invPlayer.player.level().getBlockEntity(pos, (BlockEntityType)XPSynthesiser.XP_SYNTHESISER_BLOCK_ENTITY.get()).orElseThrow(() -> new IllegalStateException("synthesiser missing at " + String.valueOf(pos))));
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)invPlayer, x, 8 + 18 * x, 142));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 84 + y * 18;
                this.addSlot(new Slot((Container)invPlayer, slotNumber, xpos, ypos));
            }
        }
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.synthesiser.itemHandler, 0, 80, 38));
        this.addDataSlots(this.synthesiser.trackedEnergy);
        this.addDataSlots(this.synthesiser.trackedProgress);
    }

    public boolean stillValid(@NotNull Player player) {
        return !this.synthesiser.isRemoved() && Vec3.atCenterOf((Vec3i)this.synthesiser.getBlockPos()).distanceToSqr(player.position()) <= 64.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.slots.get(sourceSlotIndex);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        if (sourceSlotIndex < 36) {
            if (!(sourceStack.getItem() instanceof KillRecorderItem)) return ItemStack.EMPTY;
            if (!this.moveItemStackTo(sourceStack, 36, 37, false)) {
                return ItemStack.EMPTY;
            }
        } else if (sourceSlotIndex == 36) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.err.print("Unknown slot: " + sourceSlotIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.isEmpty()) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceStack);
        return sourceStack.copy();
    }

    public XPSynthesiserBlockEntity getSynthesiser() {
        return this.synthesiser;
    }

    public boolean clickMenuButton(Player pPlayer, int pId) {
        if (pId == 1) {
            this.addLevelsToSynthesiser(pPlayer, 1);
        } else if (pId == 2) {
            this.removeLevelsFromSynthesiser(pPlayer, 1);
        } else if (pId == 3) {
            this.addLevelsToSynthesiser(pPlayer, 10);
        } else if (pId == 4) {
            this.removeLevelsFromSynthesiser(pPlayer, 10);
        }
        return false;
    }

    public void addLevelsToSynthesiser(Player player, int levels) {
        XPSynthesiserBlockEntity synthesiser = this.getSynthesiser();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.experienceLevel > 0 || serverPlayer.experienceProgress > 0.0f) {
                int currentXPProgress = (int)((float)serverPlayer.getXpNeededForNextLevel() * serverPlayer.experienceProgress);
                int toDeduct = currentXPProgress + HelperFunctions.getXPfromLevel(serverPlayer.experienceLevel) - HelperFunctions.getXPfromLevel(Math.max(serverPlayer.experienceLevel - levels + (currentXPProgress > 0 ? 1 : 0), 0));
                serverPlayer.setExperienceLevels(Math.max(serverPlayer.experienceLevel - levels + (currentXPProgress > 0 ? 1 : 0), 0));
                serverPlayer.setExperiencePoints(0);
                synthesiser.trackedProgress.set(1, synthesiser.trackedProgress.get(1) + toDeduct);
            }
        }
    }

    public void removeLevelsFromSynthesiser(Player player, int levels) {
        XPSynthesiserBlockEntity synthesiser = this.getSynthesiser();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (synthesiser.trackedProgress.get(1) > 0) {
                int amountToGive = (int)Math.ceil((float)serverPlayer.getXpNeededForNextLevel() * (1.0f - serverPlayer.experienceProgress)) + HelperFunctions.getXPfromLevel(serverPlayer.experienceLevel + levels) - HelperFunctions.getXPfromLevel(serverPlayer.experienceLevel + 1);
                if (synthesiser.trackedProgress.get(1) >= amountToGive) {
                    int newAmount = (int)((float)HelperFunctions.getXPfromLevel(serverPlayer.experienceLevel) + (float)serverPlayer.getXpNeededForNextLevel() * serverPlayer.experienceProgress) + amountToGive;
                    serverPlayer.setExperiencePoints(0);
                    serverPlayer.setExperienceLevels((int)HelperFunctions.getLevelFromXP(newAmount));
                    synthesiser.trackedProgress.set(1, synthesiser.trackedProgress.get(1) - amountToGive);
                } else {
                    double newLevels = HelperFunctions.getLevelFromXP((int)((float)HelperFunctions.getXPfromLevel(serverPlayer.experienceLevel) + (float)serverPlayer.getXpNeededForNextLevel() * serverPlayer.experienceProgress) + synthesiser.trackedProgress.get(1));
                    int newLevel = (int)Math.floor(newLevels);
                    int newPoints = (int)Math.ceil((double)(HelperFunctions.getXPfromLevel(newLevel + 1) - HelperFunctions.getXPfromLevel(newLevel)) * (newLevels - (double)newLevel));
                    serverPlayer.setExperienceLevels(newLevel);
                    serverPlayer.setExperiencePoints(newPoints);
                    synthesiser.trackedProgress.set(1, 0);
                }
            }
        }
    }
}

