/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.item;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;

public class ItemContainerToItemHandlerAdapter
implements IItemHandlerModifiable {
    private final ItemContainer container;
    private final HandlerIOBehavior behavior;

    public ItemContainerToItemHandlerAdapter(ItemContainer container, HandlerIOBehavior behavior) {
        this.container = container;
        this.behavior = behavior;
    }

    public int getSlots() {
        return this.container.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        Objects.checkIndex(slot, this.getSlots());
        return this.container.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        Preconditions.checkElementIndex((int)slot, (int)this.getSlots());
        if (stack.isEmpty() || !this.behavior.canInsert(slot) || !this.container.isValid(slot, stack)) {
            return stack;
        }
        ItemStack stackInSlot = this.container.get(slot);
        if (!stackInSlot.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) {
            return stack;
        }
        if (stackInSlot.isEmpty()) {
            int currentSize = 0;
            int inserted = Math.min(Math.min(this.container.getSlotCapacity(slot), stack.getMaxStackSize()) - currentSize, stack.getCount());
            ItemStack newStack = stack.copyWithCount(inserted);
            ItemStack leftover = stack.copy();
            leftover.shrink(inserted);
            if (!simulate) {
                this.container.set(slot, newStack);
            }
            return leftover;
        }
        int currentSize = stackInSlot.getCount();
        int inserted = Math.min(Math.min(this.container.getSlotCapacity(slot), stackInSlot.getMaxStackSize()) - currentSize, stack.getCount());
        ItemStack newStack = stackInSlot.copy();
        newStack.grow(inserted);
        if (!simulate) {
            this.container.set(slot, newStack);
        }
        ItemStack leftover = stack.copy();
        leftover.shrink(inserted);
        return leftover;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Preconditions.checkElementIndex((int)slot, (int)this.getSlots());
        if (!this.behavior.canExtract(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack currentStack = this.container.get(slot);
        if (currentStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            return currentStack.copy().split(amount);
        }
        ItemStack leftover = currentStack.copy();
        ItemStack extracted = leftover.split(amount);
        this.container.set(slot, leftover);
        return extracted;
    }

    public int getSlotLimit(int slot) {
        Objects.checkIndex(slot, this.getSlots());
        return this.container.getSlotCapacity(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        Objects.checkIndex(slot, this.getSlots());
        return this.container.isValid(slot, stack) && this.behavior.canInsert(slot);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Objects.checkIndex(slot, this.getSlots());
        this.container.set(slot, stack);
    }
}

