/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.machines.content.attachments.level.MultiTankLevelAttachment;
import tv.soaryn.xycraft.machines.content.blocks.multiblock.TankMemberBlockEntity;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankMultiBlock;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public class TankMemberAttachment {
    private static final Codec<TankMemberAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)TankMultiBlock.IDPair.CODEC.optionalFieldOf("tank1").forGetter(data -> Optional.ofNullable(TankMultiBlock.IDPair.create(data.multiBlocks[0]))), (App)TankMultiBlock.IDPair.CODEC.optionalFieldOf("tank2").forGetter(data -> Optional.ofNullable(TankMultiBlock.IDPair.create(data.multiBlocks[1])))).apply((Applicative)builder, TankMemberAttachment::new));
    public static final AttachmentType.Builder<TankMemberAttachment> builder = AttachmentType.builder(TankMemberAttachment::new).serialize(CODEC);
    public final TankMultiBlock[] multiBlocks = new TankMultiBlock[2];
    final ArrayList<TankMultiBlock.IDPair> pairs = new ArrayList(2);
    private boolean isLoaded;

    private TankMemberAttachment(IAttachmentHolder iAttachmentHolder) {
        this.pairs.add(null);
        this.pairs.add(null);
    }

    public TankMemberAttachment(Optional<TankMultiBlock.IDPair> tank1, Optional<TankMultiBlock.IDPair> tank2) {
        this.pairs.add(tank1.orElse(null));
        this.pairs.add(tank2.orElse(null));
    }

    public TankMultiBlock[] getMultiBlocks(ServerLevel level, @NotNull TankMemberBlockEntity memberBlockEntity) {
        if (this.isLoaded || level == null || this.pairs.isEmpty()) {
            return this.multiBlocks;
        }
        MultiTankLevelAttachment levelTankData = (MultiTankLevelAttachment)level.getData(MachinesAttachments.Level.LevelTankData);
        this.isLoaded = true;
        TankMultiBlock capsMultiBlockNew = null;
        int loadedNew = 0;
        for (int i = 0; i < this.multiBlocks.length; ++i) {
            TankMultiBlock.IDPair storedTank = this.pairs.get(i);
            if (storedTank != null) {
                this.multiBlocks[i] = levelTankData.getTankMultiBlock(storedTank);
                TankMultiBlock tankMultiBlock = this.multiBlocks[i];
                if (tankMultiBlock == null || !tankMultiBlock.isValid()) continue;
                capsMultiBlockNew = tankMultiBlock;
                ++loadedNew;
                continue;
            }
            this.multiBlocks[i] = null;
        }
        if (loadedNew == 1) {
            memberBlockEntity.setMultiBlock(capsMultiBlockNew);
            level.invalidateCapabilities(memberBlockEntity.getBlockPos());
        }
        memberBlockEntity.setChanged();
        return this.multiBlocks;
    }
}

