/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.proto;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.gui.ProtoMenu;

public class ProtoBlock
extends XyBlock.WithEntity {
    public ProtoBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().randomTicks().requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get()), Entity::new);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof Entity)) {
            return super.useWithoutItem(state, level, pos, player, hit);
        }
        Entity entity = (Entity)be;
        if (!level.isClientSide() && !player.isFakePlayer()) {
            player.openMenu((MenuProvider)entity, be.getBlockPos());
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public static class Entity
    extends XyBlockEntity
    implements MenuProvider {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.Proto.entity(), pos, state, new AttachmentType[0]);
        }

        @NotNull
        public Component getDisplayName() {
            return Component.translatable((String)"block.xycraft_machines.proto");
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
            return new ProtoMenu(windowId, playerInventory, (BlockEntity)this);
        }
    }
}

