/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular206;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.capabilities.modular.IAttributeModule;
import tv.soaryn.xycraft.api.content.capabilities.modular.IEnchantmentModule;
import tv.soaryn.xycraft.api.content.capabilities.modular.IEnergyConsumer;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModule;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModuleContainer;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.items.XyItem;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.MachinesModules;
import tv.soaryn.xycraft.machines.content.registries.MachinesDataComponents;

public class VariableItem
extends XyItem.Experimental {
    private final EquipmentSlotGroup _validEquipSlotForAttributes;

    public VariableItem(Item.Properties properties, EquipmentSlotGroup slotGroup) {
        super(properties.stacksTo(1).component(MachinesDataComponents.ModuleContainer, (Object)ItemContainerContents.fromItems((List)NonNullList.withSize((int)6, (Object)ItemStack.EMPTY))));
        this._validEquipSlotForAttributes = slotGroup;
    }

    public static IModuleContainer createBasicModularStorage(final ItemStack stack, Void ignored) {
        return new IModuleContainer(){

            public List<IModuleContainer.ModuleRecord> getInstalledModules() {
                ItemContainerContents container = (ItemContainerContents)stack.getOrDefault(MachinesDataComponents.ModuleContainer, (Object)ItemContainerContents.EMPTY);
                NonNullList list = NonNullList.withSize((int)6, (Object)new IModuleContainer.ModuleRecord(ItemStack.EMPTY, null));
                List<IModuleContainer.ModuleRecord> modules = container.stream().map(containedStack -> new IModuleContainer.ModuleRecord(containedStack, (IModule)containedStack.getCapability(CoreCapabilities.Module.ITEM))).toList();
                for (int i = 0; i < modules.size(); ++i) {
                    list.set(i, (Object)modules.get(i));
                }
                return list;
            }

            public void installModule(int slot, ItemStack moduleStack) {
                ItemContainerContents container = (ItemContainerContents)stack.getOrDefault(MachinesDataComponents.ModuleContainer, (Object)ItemContainerContents.EMPTY);
                NonNullList items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
                container.copyInto(items);
                items.set(slot, (Object)moduleStack);
                stack.set(MachinesDataComponents.ModuleContainer, (Object)ItemContainerContents.fromItems((List)items));
            }

            public void invalidate(RegistryAccess registryAccess) {
                Item item = stack.getItem();
                if (item instanceof VariableItem) {
                    VariableItem variableItem = (VariableItem)item;
                    stack.set(MachinesDataComponents.ModuleEnchantments, (Object)variableItem.invalidateEnchantments(this, ItemEnchantments.EMPTY.withTooltip(false), (HolderLookup.RegistryLookup<Enchantment>)registryAccess.lookupOrThrow(Registries.ENCHANTMENT)));
                    stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)variableItem.invalidateAttributes(this, ItemAttributeModifiers.EMPTY.withTooltip(false)));
                    List<IModuleContainer.ModuleRecord> modules = this.getInstalledModules();
                    Optional<IModuleContainer.ModuleRecord> highestTier = modules.stream().filter(r -> r.module() != null).max(Comparator.comparing(o -> o.module().getModuleType()));
                    if (highestTier.isEmpty()) {
                        return;
                    }
                    stack.set(DataComponents.RARITY, (Object)highestTier.get().module().getModuleType().getRarity());
                }
            }
        };
    }

    private static boolean hasArchonEfficiency(Player player, List<IModuleContainer.ModuleRecord> moduleList, float randValue, float threshold) {
        return !player.level().isClientSide() && randValue < threshold && moduleList.stream().anyMatch(moduleRecord -> moduleRecord.module() == MachinesModules.ArchonAffinity.value());
    }

    public static IEnergyConsumer createEnergyConsumer(ItemStack stack, Void ignored, ModConfigSpec.IntValue config) {
        return player -> {
            float threshold;
            int baseCost = (Integer)config.get();
            IModuleContainer cap = (IModuleContainer)stack.getCapability(CoreCapabilities.ModuleContainer.ITEM);
            if (cap == null) {
                return baseCost;
            }
            List moduleList = cap.getInstalledModules();
            int efficiencyCount = (int)moduleList.stream().filter(moduleRecord -> moduleRecord.module() == MachinesModules.Efficiency.value()).count();
            float randValue = (float)player.getRandom().nextInt(100) * 0.01f;
            if (VariableItem.hasArchonEfficiency(player, moduleList, randValue, threshold = 0.1f + (float)efficiencyCount * 0.1f)) {
                return 0;
            }
            return baseCost - efficiencyCount / baseCost;
        };
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, @NotNull List<Component> tooltips, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, ctx, tooltips, flags);
        if (flags.isAdvanced()) {
            HolderLookup.Provider registries = ctx.registries();
            if (registries == null) {
                return;
            }
            Optional lookup = registries.lookup(Registries.ENCHANTMENT);
            if (lookup.isEmpty()) {
                return;
            }
            ItemEnchantments enchantmentMap = this.getAllEnchantments(stack, (HolderLookup.RegistryLookup<Enchantment>)((HolderLookup.RegistryLookup)lookup.get()));
            for (Object2IntMap.Entry enchantmentIntegerEntry : enchantmentMap.entrySet()) {
                Holder holder = (Holder)enchantmentIntegerEntry.getKey();
                tooltips.add((Component)Component.literal((String)"  Pseudo-").withStyle(Style.EMPTY.withColor(-10066330)).append((Component)Enchantment.getFullname((Holder)holder, (int)enchantmentIntegerEntry.getIntValue()).copy().withColor(-10066330)).copy().withStyle(Style.EMPTY.withColor(-10066330)));
            }
        }
    }

    public int getEnchantmentLevel(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        IModuleContainer cap = (IModuleContainer)stack.getCapability(IModuleContainer.ITEM);
        if (cap == null) {
            return 0;
        }
        List modules = cap.getInstalledModules();
        return modules.stream().map(IModuleContainer.ModuleRecord::module).filter(module -> {
            IEnchantmentModule enchanted;
            return module instanceof IEnchantmentModule && enchantment.is((enchanted = (IEnchantmentModule)module).getEnchantment());
        }).map(module -> ((IEnchantmentModule)module).getEnchantmentLevel()).reduce(Integer::sum).orElse(0);
    }

    public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        super.onDestroyed(itemEntity, damageSource);
    }

    @NotNull
    public ItemEnchantments getAllEnchantments(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.RegistryLookup<Enchantment> lookup) {
        return (ItemEnchantments)stack.getOrDefault(MachinesDataComponents.ModuleEnchantments, (Object)ItemEnchantments.EMPTY);
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        return super.getDefaultAttributeModifiers(stack);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public ItemEnchantments invalidateEnchantments(IModuleContainer cap, ItemEnchantments empty, HolderLookup.RegistryLookup<Enchantment> enchantmentLookup) {
        if (cap == null) {
            return empty;
        }
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(empty);
        List modules = cap.getInstalledModules();
        HashMap<Holder, Integer> map = new HashMap<Holder, Integer>();
        modules.stream().map(IModuleContainer.ModuleRecord::module).filter(IEnchantmentModule.class::isInstance).map(IEnchantmentModule.class::cast).forEach(module -> {
            Holder.Reference enchantmentHolder = enchantmentLookup.get(module.getEnchantment()).orElse(null);
            if (enchantmentHolder == null) {
                return;
            }
            map.compute((Holder)enchantmentHolder, (enchantment, integer) -> integer == null ? module.getEnchantmentLevel() : integer + module.getEnchantmentLevel());
        });
        map.forEach((arg_0, arg_1) -> ((ItemEnchantments.Mutable)enchantments).set(arg_0, arg_1));
        return enchantments.toImmutable();
    }

    public ItemAttributeModifiers invalidateAttributes(IModuleContainer cap, ItemAttributeModifiers empty) {
        if (cap == null) {
            return empty;
        }
        List modules = cap.getInstalledModules();
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        modules.stream().map(IModuleContainer.ModuleRecord::module).filter(IAttributeModule.class::isInstance).map(IAttributeModule.class::cast).map(module -> module.getAttribute(this._validEquipSlotForAttributes)).mapMulti((map, consumer) -> map.entries().forEach(entry -> consumer.accept(new ImmutablePair((Object)((Holder)entry.getKey()), (Object)((AttributeModifier)entry.getValue()))))).collect(Collectors.groupingBy(pair -> new ImmutablePair((Object)((Holder)pair.getLeft()), (Object)((AttributeModifier)pair.getRight()).id()))).forEach((key, value) -> {
            double amount = 0.0;
            Optional templateModifier = value.stream().findAny();
            if (templateModifier.isEmpty()) {
                return;
            }
            AttributeModifier resolved = (AttributeModifier)((ImmutablePair)templateModifier.get()).getRight();
            for (ImmutablePair attributeModifierPairs : value) {
                amount += ((AttributeModifier)attributeModifierPairs.getRight()).amount();
            }
            Holder attribute = (Holder)key.getLeft();
            ResourceLocation id = (ResourceLocation)key.getRight();
            builder.add(attribute, new AttributeModifier(id, amount, resolved.operation()), this._validEquipSlotForAttributes);
        });
        return builder.build().withTooltip(false);
    }
}

