/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.producers;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.SimpleResourceFluidContainer;
import tv.soaryn.xycraft.core.container.SimpleResourceItemContainer;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.protocontainer.FluidResource;
import tv.soaryn.xycraft.core.utils.protocontainer.IResourceHandler;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;
import tv.soaryn.xycraft.core.utils.resources.FluidUtils;
import tv.soaryn.xycraft.machines.content.multiblock.producers.ProcessorFactories;

public class CryoChamberInventory {
    public static final Codec<CryoChamberInventory> CODEC = ProcessorFactories.Hybrid.producerCodec(CryoChamberInventory::new, data -> data._items, data -> data._fluids, data -> data._fluids.getCapacity(), data -> Optional.ofNullable(data.SelectedRecipe));
    @Nullable
    public ResourceLocation SelectedRecipe;
    private final SimpleResourceItemContainer _items;
    private final SimpleResourceFluidContainer _fluids;
    public final transient IResourceContainer<ItemResource> InputItem;
    public final transient IResourceContainer<ItemResource> OutputItem;
    public final transient IResourceContainer<FluidResource> InputFluid;
    public final transient IResourceContainer<FluidResource> OutputFluid;
    public final transient IResourceHandler<ItemResource> InputItemHandler;
    public final transient IResourceHandler<ItemResource> OutputItemHandler;
    public final transient IResourceHandler<FluidResource> InputFluidHandler;
    public final transient IResourceHandler<FluidResource> OutputFluidHandler;

    public static CryoChamberInventory create() {
        return new CryoChamberInventory((NonNullList<MutableResourceStack<ItemResource>>)MutableResourceStack.Empty.ITEM.nonNullListOfSize(10), (NonNullList<MutableResourceStack<FluidResource>>)MutableResourceStack.Empty.FLUID.nonNullListOfSize(2), FluidUtils.inBuckets((int)4), Optional.empty());
    }

    private CryoChamberInventory(NonNullList<MutableResourceStack<ItemResource>> items, NonNullList<MutableResourceStack<FluidResource>> fluids, int capacity, Optional<ResourceLocation> recipeId) {
        this._items = SimpleResourceItemContainer.from(items, this::onChanged);
        this._fluids = SimpleResourceFluidContainer.from(fluids, (int)capacity, this::onChanged);
        this.SelectedRecipe = recipeId.orElse(null);
        this.InputItem = this._items.slice(0, 1);
        this.OutputItem = this._items.slice(1, 9);
        this.InputFluid = this._fluids.slice(0, 1);
        this.OutputFluid = this._fluids.slice(1, 1);
        this.InputItemHandler = this.InputItem.asHandler(HandlerIOBehavior.INSERT_ONLY);
        this.OutputItemHandler = this.OutputItem.asHandler(HandlerIOBehavior.EXTRACT_ONLY);
        this.InputFluidHandler = this.InputFluid.asHandler(HandlerIOBehavior.INSERT_ONLY);
        this.OutputFluidHandler = this.OutputFluid.asHandler(HandlerIOBehavior.EXTRACT_ONLY);
    }

    public void onChanged() {
    }
}

