/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.buildings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContainer;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;
import tv.soaryn.xycraft.core.content.recipe.IRecipeWithStage;
import tv.soaryn.xycraft.core.content.recipe.RecipeContent;
import tv.soaryn.xycraft.core.content.recipe.RecipeSerDes;
import tv.soaryn.xycraft.core.content.stages.IXyStage;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public record BuildingsRecipe(List<Either<SizedFluidIngredient, SizedIngredient>> input, Optional<IStage> requiredStage) implements IRecipeContent<Container, BuildingsRecipe>,
IRecipeWithStage
{
    private static final MapCodec<BuildingsRecipe> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CodecUtils.Codecs.ContentObjectIngredient.listOf().fieldOf("ingredient").forGetter(BuildingsRecipe::input), (App)IXyStage.CODEC.optionalFieldOf("stage_required").forGetter(BuildingsRecipe::requiredStage)).apply((Applicative)builder, BuildingsRecipe::new));
    private static final BinarySerializer<BuildingsRecipe> SerDes = BinarySerializer.ofType(BuildingsRecipe::new, BuildingsRecipe::input, (BinarySerializer)BinarySerializer.ofCollection(ArrayList::new, (BinarySerializer)BinarySerializer.eitherOf((BinarySerializer)Serializer.SIZED_FLUID_INGREDIENT, (BinarySerializer)Serializer.SIZED_INGREDIENT)), BuildingsRecipe::requiredStage, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)IXyStage.SerDes));

    public static RecipeSerDes<BuildingsRecipe> register() {
        return RecipeSerDes.create(codec, SerDes);
    }

    public RecipeContent<BuildingsRecipe> getContent() {
        return MachinesRecipeTypes.Buildings;
    }

    public boolean matches(@NotNull Container container, @NotNull Level level) {
        SimpleItemContainer snapShotInventory = SimpleItemContainer.from(container.getInventory());
        IItemHandlerModifiable handler = snapShotInventory.asHandler();
        return this.input.stream().filter(either -> either.right().isPresent()).map(either -> (SizedIngredient)either.right().get()).allMatch(ingredient -> {
            int handledAmount = 0;
            for (int i = 0; i < snapShotInventory.size(); ++i) {
                ItemStack stack = snapShotInventory.get(i);
                if (stack.isEmpty() || !ingredient.test(stack)) continue;
                int amount = ingredient.count() - handledAmount;
                ItemStack received = handler.extractItem(i, amount, false);
                if (received.getCount() == amount) {
                    return true;
                }
                handledAmount += received.getCount();
            }
            return false;
        });
    }

    public Optional<IStage> getRequiredStage() {
        return this.requiredStage();
    }

    public static interface Container
    extends IRecipeContainer {
        public NonNullList<ItemStack> getInventory();
    }
}

